/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.mule.tools.api.packager.DefaultProjectInformation;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.validation.exchange.ExchangeRepositoryMetadata;
import org.mule.tools.client.authentication.model.Credentials;
import org.mule.tools.maven.utils.DependencyProject;
import org.mule.tools.maven.utils.ResolvedPom;
import org.mule.tools.model.Deployment;

public class MavenProjectInformation
implements ProjectInformation {
    private ProjectInformation projectInformation;
    private static final MavenProjectInformation mavenProjectInformation = new MavenProjectInformation();

    private MavenProjectInformation() {
    }

    public static MavenProjectInformation getProjectInformation(MavenSession session, MavenProject project, File projectBaseFolder, boolean testJar, List<Deployment> deployments, String classifier) {
        DefaultProjectInformation.Builder builder = new DefaultProjectInformation.Builder();
        boolean isDeployment = session.getGoals().stream().anyMatch(goal -> StringUtils.containsIgnoreCase((CharSequence)goal, (CharSequence)"deploy"));
        builder.withGroupId(project.getGroupId()).withArtifactId(project.getArtifactId()).withVersion(project.getVersion()).withPackaging(project.getPackaging()).withClassifier(classifier).withProjectBaseFolder(Paths.get(projectBaseFolder.toURI())).withBuildDirectory(Paths.get(project.getBuild().getDirectory(), new String[0])).setTestProject(Boolean.valueOf(testJar)).withDependencyProject((Project)new DependencyProject(project)).isDeployment(isDeployment).withResolvedPom((Pom)new ResolvedPom(project.getModel()));
        if (isDeployment) {
            Settings settings;
            DistributionManagement management = project.getDistributionManagement();
            DeploymentRepository repository = management != null ? management.getRepository() : null;
            Optional<ExchangeRepositoryMetadata> metadata = MavenProjectInformation.getExchangeRepositoryMetadata(repository, settings = session.getSettings());
            if (metadata.isPresent()) {
                builder.withExchangeRepositoryMetadata(metadata.get());
            } else {
                builder.withDeployments(deployments);
            }
        }
        MavenProjectInformation.mavenProjectInformation.projectInformation = builder.build();
        return mavenProjectInformation;
    }

    public String getGroupId() {
        return this.projectInformation.getGroupId();
    }

    public String getArtifactId() {
        return this.projectInformation.getArtifactId();
    }

    public String getVersion() {
        return this.projectInformation.getVersion();
    }

    public String getClassifier() {
        return this.projectInformation.getClassifier();
    }

    public String getPackaging() {
        return this.projectInformation.getPackaging();
    }

    public Path getProjectBaseFolder() {
        return this.projectInformation.getProjectBaseFolder();
    }

    public Path getBuildDirectory() {
        return this.projectInformation.getBuildDirectory();
    }

    public boolean isTestProject() {
        return this.projectInformation.isTestProject();
    }

    public Project getProject() {
        return this.projectInformation.getProject();
    }

    public Optional<ExchangeRepositoryMetadata> getExchangeRepositoryMetadata() {
        return this.projectInformation.getExchangeRepositoryMetadata();
    }

    public boolean isDeployment() {
        return this.projectInformation.isDeployment();
    }

    public List<Deployment> getDeployments() {
        return this.projectInformation.getDeployments();
    }

    public Pom getEffectivePom() {
        return this.projectInformation.getEffectivePom();
    }

    private static Optional<ExchangeRepositoryMetadata> getExchangeRepositoryMetadata(DeploymentRepository repository, Settings settings) {
        Server server;
        ExchangeRepositoryMetadata metadata = null;
        if (repository != null && ExchangeRepositoryMetadata.isExchangeRepo((String)repository.getUrl()) && (server = settings.getServer(repository.getId())) != null) {
            Credentials credentials = new Credentials(server.getUsername(), server.getPassword());
            metadata = new ExchangeRepositoryMetadata(credentials, repository.getUrl());
        }
        return Optional.ofNullable(metadata);
    }
}

