/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.utils;

import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.maven.utils.ArtifactUtils;

public class ResolvedPom
implements Pom {
    private final Model pomModel;

    public ResolvedPom(Model pomModel) {
        Preconditions.checkArgument((pomModel != null ? 1 : 0) != 0, (Object)"Pom model should not be null");
        this.pomModel = pomModel;
    }

    public String getGroupId() {
        return this.pomModel.getGroupId();
    }

    public String getArtifactId() {
        return this.pomModel.getArtifactId();
    }

    public String getVersion() {
        return this.pomModel.getVersion();
    }

    public List<ArtifactCoordinates> getDependencies() {
        return this.pomModel.getDependencies().stream().map(ArtifactUtils::toArtifactCoordinates).collect(Collectors.toList());
    }

    public void persist(Path pom) throws IOException {
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try (FileOutputStream outputStream = new FileOutputStream(pom.toFile());){
            writer.write((OutputStream)outputStream, this.pomModel);
        }
    }

    public List<Path> getResourcesLocation() {
        return this.pomModel.getBuild().getResources().stream().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }
}

