/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.resources.processor.DomainBundleProjectResourcesContentProcessor;
import org.mule.tools.api.packager.resources.processor.ResourcesContentProcessor;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="process-resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ProcessResourcesMojo
extends AbstractMuleMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            Optional<ResourcesContentProcessor> resourcesContentProcessor = this.getResourcesContentProcessor();
            if (resourcesContentProcessor.isPresent()) {
                resourcesContentProcessor.get().process(resourcesContent);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoFailureException("Fail to process resources", (Throwable)e);
        }
    }

    protected Optional<ResourcesContentProcessor> getResourcesContentProcessor() {
        PackagingType packaging = PackagingType.fromString((String)this.getAndSetProjectInformation().getPackaging());
        if (packaging == PackagingType.MULE_DOMAIN_BUNDLE) {
            return Optional.of(new DomainBundleProjectResourcesContentProcessor(Paths.get(this.project.getBuild().getDirectory(), new String[0])));
        }
        return Optional.empty();
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_PROCESS_RESOURCES_PREVIOUS_RUN_PLACEHOLDER";
    }
}

