/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.repository.MuleMavenPluginClientBuilder;
import org.mule.tools.api.util.PackagerLog;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.validation.exchange.ExchangeRepositoryMetadata;
import org.mule.tools.api.validation.project.AbstractProjectValidator;
import org.mule.tools.api.validation.project.ProjectValidatorFactory;
import org.mule.tools.client.authentication.model.Credentials;
import org.mule.tools.maven.utils.ArtifactUtils;
import org.mule.tools.maven.utils.DependencyProject;
import org.mule.tools.maven.utils.MavenPackagerLog;
import org.mule.tools.maven.utils.ProjectDirectoryUpdater;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.model.standalone.ClusterDeployment;
import org.mule.tools.model.standalone.StandaloneDeployment;

public abstract class AbstractGenericMojo
extends AbstractMojo {
    @Parameter
    protected CloudHubDeployment cloudHubDeployment;
    @Parameter
    protected ArmDeployment armDeployment;
    @Parameter
    protected StandaloneDeployment standaloneDeployment;
    @Parameter
    protected AgentDeployment agentDeployment;
    @Parameter
    protected ClusterDeployment clusterDeployment;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Parameter(readonly=true, required=true, defaultValue="${session}")
    protected MavenSession session;
    @Parameter(property="project", required=true)
    protected MavenProject project;
    @Parameter(property="shared.libraries")
    protected List<SharedLibraryDependency> sharedLibraries;
    @Parameter(defaultValue="${strictCheck}")
    protected boolean strictCheck;
    @Parameter(defaultValue="${project.basedir}")
    protected File projectBaseFolder;
    @Parameter(defaultValue="${projectBuildDirectory}")
    protected String projectBuildDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${testJar}")
    protected boolean testJar = false;
    @Parameter
    protected String classifier;
    @Parameter(defaultValue="${lightweightPackage}")
    protected boolean lightweightPackage = false;
    protected AbstractProjectValidator validator;
    protected AetherMavenClient aetherMavenClient;
    private ProjectInformation projectInformation;

    public abstract String getPreviousRunPlaceholder();

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public void initMojo() {
        if (this.projectBuildDirectory != null) {
            new ProjectDirectoryUpdater(this.project).updateBuildDirectory(this.projectBuildDirectory);
        }
    }

    public void setCloudHubDeployment(CloudHubDeployment cloudHubDeployment) {
        this.cloudHubDeployment = cloudHubDeployment;
    }

    public void setArmDeployment(ArmDeployment armDeployment) {
        this.armDeployment = armDeployment;
    }

    public void setStandaloneDeployment(StandaloneDeployment standaloneDeployment) {
        this.standaloneDeployment = standaloneDeployment;
    }

    public void setAgentDeployment(AgentDeployment agentDeployment) {
        this.agentDeployment = agentDeployment;
    }

    public void setClusterDeployment(ClusterDeployment clusterDeployment) {
        this.clusterDeployment = clusterDeployment;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setProjectBaseFolder(File projectBaseFolder) {
        this.projectBaseFolder = projectBaseFolder;
    }

    public AbstractProjectValidator getProjectValidator() {
        if (this.validator == null) {
            this.validator = ProjectValidatorFactory.create((ProjectInformation)this.getAndSetProjectInformation(), (AetherMavenClient)this.getAetherMavenClient(), this.sharedLibraries, (boolean)this.strictCheck);
        }
        return this.validator;
    }

    protected AetherMavenClient getAetherMavenClient() {
        if (this.aetherMavenClient == null) {
            MavenExecutionRequest request = this.session.getRequest();
            List remoteRepositories = RepositoryUtils.toRepos(this.remoteArtifactRepositories);
            this.aetherMavenClient = new MuleMavenPluginClientBuilder((PackagerLog)new MavenPackagerLog(this.getLog())).withRemoteRepositories(remoteRepositories).withLocalRepository(request.getLocalRepositoryPath()).withUserSettings(request.getUserSettingsFile()).withGlobalSettings(request.getGlobalSettingsFile()).build();
        }
        return this.aetherMavenClient;
    }

    protected List<ArtifactCoordinates> toArtifactCoordinates(List<Dependency> dependencies) {
        return dependencies.stream().map(ArtifactUtils::toArtifactCoordinates).collect(Collectors.toList());
    }

    protected ProjectInformation getAndSetProjectInformation() {
        ProjectInformation.Builder builder = new ProjectInformation.Builder();
        if (this.projectInformation == null) {
            boolean isDeployment = this.session.getGoals().stream().anyMatch(goal -> StringUtils.equals((CharSequence)goal, (CharSequence)"deploy"));
            builder.withGroupId(this.project.getGroupId()).withArtifactId(this.project.getArtifactId()).withVersion(this.project.getVersion()).withPackaging(this.project.getPackaging()).withClassifier(this.getClassifier()).withProjectBaseFolder(Paths.get(this.projectBaseFolder.toURI())).withBuildDirectory(Paths.get(this.project.getBuild().getDirectory(), new String[0])).setTestProject(Boolean.valueOf(this.testJar)).withDependencyProject((Project)new DependencyProject(this.project)).isDeployment(isDeployment);
            if (isDeployment) {
                Settings settings;
                DistributionManagement management = this.project.getDistributionManagement();
                DeploymentRepository repository = management != null ? management.getRepository() : null;
                Optional<ExchangeRepositoryMetadata> metadata = this.getExchangeRepositoryMetadata(repository, settings = this.session.getSettings());
                if (metadata.isPresent()) {
                    builder.withExchangeRepositoryMetadata(metadata.get());
                } else {
                    builder.withDeployments(Arrays.asList(this.agentDeployment, this.standaloneDeployment, this.armDeployment, this.cloudHubDeployment, this.clusterDeployment));
                }
            }
            this.projectInformation = builder.build();
        }
        return this.projectInformation;
    }

    protected boolean hasExecutedBefore() {
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(this.getPreviousRunPlaceholder())) {
            return true;
        }
        this.getPluginContext().put(this.getPreviousRunPlaceholder(), this.getPreviousRunPlaceholder());
        return false;
    }

    private Optional<ExchangeRepositoryMetadata> getExchangeRepositoryMetadata(DeploymentRepository repository, Settings settings) {
        ExchangeRepositoryMetadata metadata = null;
        if (repository != null && ExchangeRepositoryMetadata.isExchangeRepo((String)repository.getUrl())) {
            Server server = settings.getServer(repository.getId());
            Credentials credentials = new Credentials(server.getUsername(), server.getPassword());
            metadata = new ExchangeRepositoryMetadata(credentials, repository.getUrl());
        }
        return Optional.ofNullable(metadata);
    }

    protected PackagingType getPackagingType() {
        return PackagingType.fromString((String)this.project.getPackaging());
    }

    public String getClassifier() {
        return this.getPackagingType().resolveClassifier(this.classifier, this.lightweightPackage, this.testJar);
    }
}

