/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;

public class CopyFileVisitor
implements FileVisitor<Path> {
    private final File fromFolder;
    private final File targetFolder;
    private List<Path> exclusions = Collections.emptyList();

    public CopyFileVisitor(File fromFolder, File targetFolder) {
        this.fromFolder = fromFolder;
        this.targetFolder = targetFolder;
    }

    public void setExclusions(List<Path> exclusions) {
        this.exclusions = exclusions;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.exclusions.contains(dir)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        Path targetPath = this.targetFolder.toPath().resolve(this.fromFolder.toPath().relativize(dir));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            Files.createDirectory(targetPath, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.copy(file, this.targetFolder.toPath().resolve(this.fromFolder.toPath().relativize(file)), StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

