/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.maven.dependency.MulePluginsCompatibilityValidator;
import org.mule.tools.maven.dependency.resolver.MulePluginResolver;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.mojo.model.PackagingType;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public class ValidateMojo
extends AbstractMuleMojo {
    protected MulePluginResolver resolver;
    protected MulePluginsCompatibilityValidator validator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Validating Mule application...");
        this.validateMandatoryFolders();
        this.validateMandatoryDescriptors();
        this.validateMulePluginDependencies();
        this.validateSharedLibraries();
        this.getLog().debug((CharSequence)"Validating Mule application done");
    }

    protected void validateSharedLibraries() throws MojoExecutionException {
        Set sharedLibrariesCoordinates;
        Set projectDependenciesCoordinates;
        if (this.sharedLibraries != null && this.sharedLibraries.size() != 0 && !(projectDependenciesCoordinates = this.project.getDependencies().stream().map(dependency -> dependency.getArtifactId() + ":" + dependency.getGroupId()).collect(Collectors.toSet())).containsAll(sharedLibrariesCoordinates = this.sharedLibraries.stream().map(dependency -> dependency.getArtifactId() + ":" + dependency.getGroupId()).collect(Collectors.toSet()))) {
            sharedLibrariesCoordinates.removeAll(projectDependenciesCoordinates);
            throw new MojoExecutionException("The mule application does not contain the following shared libraries: " + sharedLibrariesCoordinates.toString());
        }
    }

    private void validateMandatoryFolders() throws MojoExecutionException {
        if (!this.getSourceFolder().exists()) {
            String message = String.format("Invalid Mule project. Missing src/main/" + (PackagingType.MULE_POLICY.equals(this.project.getPackaging()) ? "policy" : "mule") + " folder. This folder is mandatory", new Object[0]);
            throw new MojoExecutionException(message);
        }
    }

    private void validateMandatoryDescriptors() throws MojoExecutionException {
        this.isFilePresent("Invalid Mule project. Missing %s file, it must be present in the root of application", PackagingType.MULE_POLICY.equals(this.project.getPackaging()) ? "mule-policy.json" : "mule-application.json");
    }

    private void isFilePresent(String message, String ... fileName) throws MojoExecutionException {
        List files = Arrays.stream(fileName).map(name -> Paths.get(this.projectBaseFolder.toString(), name).toFile()).collect(Collectors.toList());
        if (files.stream().allMatch(file -> !file.exists())) {
            throw new MojoExecutionException(String.format(message, fileName));
        }
    }

    private void validateMulePluginDependencies() throws MojoExecutionException {
        this.initializeResolver();
        this.initializeValidator();
        this.validator.validate(this.resolver.resolveMulePlugins(this.project));
    }

    protected void initializeResolver() {
        this.resolver = new MulePluginResolver(this.getLog(), this.session, this.projectBuilder, this.repositorySystem, this.localRepository, this.remoteArtifactRepositories);
    }

    protected void initializeValidator() {
        this.validator = new MulePluginsCompatibilityValidator();
    }
}

