/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.artifact.archiver.internal.PackageBuilder;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.mojo.model.PackagingType;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PackageMojo
extends AbstractMuleMojo {
    private static final String TYPE = "zip";
    @Component
    protected MavenProjectHelper helper;
    @Parameter(defaultValue="${finalName}")
    protected String finalName;
    @Parameter(defaultValue="${onlyMuleSources}")
    protected boolean onlyMuleSources = false;
    @Parameter(defaultValue="${attachMuleSources}")
    protected boolean attachMuleSources = false;
    protected PackageBuilder packageBuilder;
    protected PackagingType packagingType;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.packagingType = PackagingType.fromString(this.project.getPackaging());
        String targetFolder = this.project.getBuild().getDirectory();
        File destinationFile = this.getDestinationFile(targetFolder);
        try {
            this.createMuleApp(destinationFile, targetFolder);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)((Object)e));
        }
        this.helper.attachArtifact(this.project, TYPE, this.packagingType.resolveClassifier(this.classifier, this.lightwayPackage), destinationFile);
    }

    private File getDestinationFile(String targetFolder) throws MojoExecutionException {
        Path destinationPath = Paths.get(targetFolder, this.getFinalName() + "." + TYPE);
        try {
            Files.deleteIfExists(destinationPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Exception deleting the file [%s]", destinationPath), (Exception)e);
        }
        return destinationPath.toFile();
    }

    protected String getFinalName() {
        if (this.finalName == null) {
            this.finalName = this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + this.packagingType.resolveClassifier(this.classifier, this.lightwayPackage);
        }
        this.getLog().debug((CharSequence)("Using final name: " + this.finalName));
        return this.finalName;
    }

    protected void createMuleApp(File destinationFile, String targetFolder) throws MojoExecutionException, ArchiverException {
        this.initializePackageBuilder();
        try {
            PackageBuilder builder = this.packageBuilder.withDestinationFile(destinationFile);
            if (!this.onlyMuleSources) {
                builder.withClasses(new File(targetFolder + File.separator + "classes")).withMaven(new File(targetFolder + File.separator + "META-INF" + File.separator + "maven")).withMuleArtifact(new File(targetFolder + File.separator + "META-INF" + File.separator + "mule-artifact"));
                if (PackagingType.MULE_POLICY.equals(this.project.getPackaging())) {
                    builder.withPolicy(new File(targetFolder + File.separator + "policy"));
                } else {
                    builder.withMule(new File(targetFolder + File.separator + "mule"));
                }
                if (!this.lightwayPackage) {
                    builder.withRepository(new File(targetFolder + File.separator + "repository"));
                }
                if (this.attachMuleSources) {
                    builder.withMuleSrc(new File(targetFolder + File.separator + "META-INF" + File.separator + "mule-src"));
                }
            } else {
                builder.withMuleSrc(new File(targetFolder + File.separator + "META-INF" + File.separator + "mule-src"));
            }
            builder.createDeployableFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create archive");
        }
    }

    protected void initializePackageBuilder() {
        this.packageBuilder = new PackageBuilder();
    }
}

