/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.mojo.model.PackagingType;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class InitializeMojo
extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Initializing Mule Maven Plugin...");
        String groupId = this.project.getGroupId();
        String artifactId = this.project.getArtifactId();
        String targetFolder = this.project.getBuild().getDirectory();
        this.createFolderIfNecessary(targetFolder);
        this.createFolderIfNecessary(targetFolder, PackagingType.MULE_POLICY.equals(this.project.getPackaging()) ? "policy" : "mule");
        this.createFolderIfNecessary(targetFolder, "test-mule");
        this.createFolderIfNecessary(targetFolder, "test-mule", "munit");
        this.createFolderIfNecessary(targetFolder, "META-INF");
        this.createFolderIfNecessary(targetFolder, "META-INF", "mule-src");
        this.createFolderIfNecessary(targetFolder, "META-INF", "mule-src", artifactId);
        this.createFolderIfNecessary(targetFolder, "META-INF", "maven");
        this.createFolderIfNecessary(targetFolder, "META-INF", "maven", groupId);
        this.createFolderIfNecessary(targetFolder, "META-INF", "maven", groupId, artifactId);
        this.createFolderIfNecessary(targetFolder, "META-INF", "mule-artifact");
        this.createFolderIfNecessary(targetFolder, "repository");
        this.getLog().debug((CharSequence)"Mule Maven Plugin Initialize done");
    }
}

