/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.util.CopyFileVisitor;

@Mojo(name="generate-test-sources", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateTestSourcesMojo
extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Creating target content with Test Mule source code...");
        try {
            this.createTestMuleFolderContent();
        }
        catch (IOException e) {
            throw new MojoFailureException("Fail to generate sources", (Throwable)e);
        }
    }

    private void createTestMuleFolderContent() throws IOException {
        File targetFolder = Paths.get(this.project.getBuild().getDirectory(), "test-mule", "munit").toFile();
        Files.walkFileTree(this.munitSourceFolder.toPath(), new CopyFileVisitor(this.munitSourceFolder, targetFolder));
    }
}

