/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.mojo.model.PackagingType;
import org.mule.tools.maven.util.CopyFileVisitor;
import org.mule.tools.maven.util.ProjectBaseFolderFileCloner;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateSourcesMojo
extends AbstractMuleMojo {
    protected ProjectBaseFolderFileCloner projectBaseFolderFileCloner;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Creating target content with Mule source code...");
        this.projectBaseFolderFileCloner = new ProjectBaseFolderFileCloner(this.project);
        try {
            this.createSrcFolderContent();
            this.createMetaInfMuleSourceFolderContent();
            this.createDescriptors();
        }
        catch (IOException e) {
            throw new MojoFailureException("Fail to generate sources", (Throwable)e);
        }
    }

    protected void createSrcFolderContent() throws IOException, MojoExecutionException {
        String srcFolderName = PackagingType.MULE_POLICY.equals(this.project.getPackaging()) ? "policy" : "mule";
        File targetFolder = Paths.get(this.project.getBuild().getDirectory(), srcFolderName).toFile();
        Files.walkFileTree(this.getSourceFolder().toPath(), new CopyFileVisitor(this.getSourceFolder(), targetFolder));
    }

    protected void createMetaInfMuleSourceFolderContent() throws IOException {
        File targetFolder = Paths.get(this.project.getBuild().getDirectory(), "META-INF", "mule-src", this.project.getArtifactId()).toFile();
        CopyFileVisitor visitor = new CopyFileVisitor(this.projectBaseFolder, targetFolder);
        ArrayList<Path> exclusions = new ArrayList<Path>();
        exclusions.add(Paths.get(this.projectBaseFolder.toPath().toString(), "target"));
        visitor.setExclusions(exclusions);
        Files.walkFileTree(this.projectBaseFolder.toPath(), visitor);
    }

    private void createDescriptors() throws IOException, MojoExecutionException {
        this.createPomProperties();
        this.createDescriptorFilesContent();
    }

    protected void createDescriptorFilesContent() throws IOException {
        this.projectBaseFolderFileCloner.clone("pom.xml").toPath("META-INF", "maven", this.project.getGroupId(), this.project.getArtifactId());
        String jsonDescriptorFileName = PackagingType.MULE_POLICY.equals(this.project.getPackaging()) ? "mule-policy.json" : "mule-application.json";
        this.projectBaseFolderFileCloner.clone(jsonDescriptorFileName).toPath("META-INF", "mule-artifact");
    }

    protected void createPomProperties() throws IOException, MojoExecutionException {
        Path pomPropertiesFilePath = Paths.get(this.project.getBuild().getDirectory(), "META-INF", "maven", this.project.getGroupId(), this.project.getArtifactId(), "pom.properties");
        try {
            PrintWriter writer = new PrintWriter(pomPropertiesFilePath.toString(), "UTF-8");
            writer.println("version=" + this.project.getVersion());
            writer.println("groupId=" + this.project.getGroupId());
            writer.println("artifactId=" + this.project.getArtifactId());
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create pom.properties", (Exception)e);
        }
    }
}

