/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import org.apache.maven.plugin.MojoExecutionException;

public class FileUtils {
    public static void markAsReadOnly(File file) throws IOException {
        Path filePath;
        FileStore fileStore;
        boolean succeeded = file.setReadOnly();
        if (!succeeded && (fileStore = Files.getFileStore(filePath = file.toPath())).supportsFileAttributeView(DosFileAttributeView.class)) {
            DosFileAttributeView fileAttributeView = Files.getFileAttributeView(filePath, DosFileAttributeView.class, new LinkOption[0]);
            fileAttributeView.setReadOnly(true);
        }
    }

    public static void checkReadOnly(File file) throws IOException, MojoExecutionException {
        DosFileAttributeView fileAttributeView;
        Path repositoryPath = file.toPath();
        FileStore fileStore = Files.getFileStore(repositoryPath);
        if (fileStore.supportsFileAttributeView(DosFileAttributeView.class) && (fileAttributeView = Files.getFileAttributeView(repositoryPath, DosFileAttributeView.class, new LinkOption[0])).readAttributes().isReadOnly()) {
            throw new IOException("File is not writable");
        }
    }
}

