/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.repository;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.mule.tools.maven.repository.ArtifactInstaller;
import org.mule.tools.maven.repository.ArtifactLocator;
import org.mule.tools.maven.repository.MavenProjectBuilder;
import org.mule.tools.maven.util.FileUtils;

public class RepositoryGenerator {
    private final RepositorySystemSession aetherRepositorySystemSession;
    private final RepositorySystem aetherRepositorySystem;
    private Log log;
    private MavenSession session;
    private MavenProject project;
    private ProjectBuilder projectBuilder;
    private org.apache.maven.repository.RepositorySystem repositorySystem;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    protected File outputDirectory;
    private ProjectBuildingRequest projectBuildingRequest;

    public RepositoryGenerator(MavenSession session, MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories, File outputDirectory, Log log, RepositorySystem aetherRepositorySystem, RepositorySystemSession aetherRepositorySystemSession, org.apache.maven.repository.RepositorySystem repositorySystem, ProjectBuilder projectBuilder) {
        this.log = log;
        this.session = session;
        this.project = project;
        this.projectBuilder = projectBuilder;
        this.repositorySystem = repositorySystem;
        this.localRepository = localRepository;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.outputDirectory = outputDirectory;
        this.aetherRepositorySystem = aetherRepositorySystem;
        this.aetherRepositorySystemSession = aetherRepositorySystemSession;
        this.repositorySystem = repositorySystem;
        this.projectBuilder = projectBuilder;
    }

    public void generate() throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)String.format("Mirroring repository for [%s]", this.project.toString()));
        try {
            this.initializeProjectBuildingRequest();
            ArtifactLocator artifactLocator = this.buildArtifactLocator();
            File pomFile = this.project.getFile();
            Set<Artifact> artifacts = artifactLocator.getArtifacts(pomFile, this.outputDirectory);
            File repositoryFolder = this.getRepositoryFolder();
            ArtifactInstaller artifactInstaller = this.buildArtifactInstaller(this.remoteArtifactRepositories);
            this.installArtifacts(repositoryFolder, artifacts, artifactInstaller);
            Set<Artifact> excludedArtifacts = artifactLocator.getExclusions();
            this.generateExcludedDependenciesMetadata(repositoryFolder, excludedArtifacts, artifactInstaller);
        }
        catch (Exception e) {
            this.log.debug((CharSequence)String.format("There was an exception while building [%s]", this.project.toString()), (Throwable)e);
        }
    }

    private void generateExcludedDependenciesMetadata(File repositoryFile, Set<Artifact> excludedArtifacts, ArtifactInstaller installer) throws MojoExecutionException {
        TreeSet<Artifact> sortedArtifacts = new TreeSet<Artifact>(excludedArtifacts);
        for (Artifact artifact : sortedArtifacts) {
            installer.downloadExcludedDependencyToLocalRepository(artifact);
            installer.generateExcludedDependencyMetadata(repositoryFile, artifact);
        }
    }

    protected ArtifactInstaller buildArtifactInstaller(List<ArtifactRepository> remoteArtifactRepositories) {
        return new ArtifactInstaller(this.log, remoteArtifactRepositories, this.aetherRepositorySystem, this.aetherRepositorySystemSession);
    }

    protected ArtifactLocator buildArtifactLocator() {
        List remoteRepositories = RepositoryUtils.toRepos(this.remoteArtifactRepositories);
        MavenProjectBuilder mavenProjectBuilder = new MavenProjectBuilder(this.projectBuilder, this.projectBuildingRequest, this.repositorySystem, this.log);
        return new ArtifactLocator(remoteRepositories, this.project, this.localRepository, mavenProjectBuilder, this.log);
    }

    protected void initializeProjectBuildingRequest() {
        this.projectBuildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        this.projectBuildingRequest.setLocalRepository(this.localRepository);
        this.projectBuildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        this.log.debug((CharSequence)String.format("Local repository [%s]", this.projectBuildingRequest.getLocalRepository().getBasedir()));
        this.projectBuildingRequest.getRemoteRepositories().forEach(artifactRepository -> this.log.debug((CharSequence)String.format("Remote repository ID [%s], URL [%s]", artifactRepository.getId(), artifactRepository.getUrl())));
    }

    protected File getRepositoryFolder() {
        File repositoryFolder = new File(this.outputDirectory, "repository");
        if (!repositoryFolder.exists()) {
            repositoryFolder.mkdirs();
        }
        return repositoryFolder;
    }

    protected void installArtifacts(File repositoryFile, Set<Artifact> artifacts, ArtifactInstaller installer) throws MojoExecutionException {
        TreeSet<Artifact> sortedArtifacts = new TreeSet<Artifact>(artifacts);
        if (sortedArtifacts.isEmpty()) {
            this.generateMarkerFileInRepositoryFolder(repositoryFile);
        }
        for (Artifact artifact : sortedArtifacts) {
            installer.installArtifact(repositoryFile, artifact);
        }
    }

    protected void generateMarkerFileInRepositoryFolder(File repositoryFile) throws MojoExecutionException {
        File markerFile = new File(repositoryFile, ".marker");
        this.log.info((CharSequence)String.format("No artifacts to add, adding marker file <%s/%s>", "repository", markerFile.getName()));
        try {
            FileUtils.checkReadOnly(repositoryFile);
            markerFile.createNewFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("The current repository has no artifacts to install, and trying to create [%s] failed", markerFile.toString()), (Exception)e);
        }
    }
}

