/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.repository;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public class ArtifactInstaller {
    private static final String POM_FILE_NAME = "pom.xml";
    private final List<ArtifactRepository> remoteRepositories;
    private Log log;
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;

    public ArtifactInstaller(Log log, List<ArtifactRepository> remoteArtifactRepositories, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession) {
        this.log = log;
        this.remoteRepositories = remoteArtifactRepositories;
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
    }

    protected List<RemoteRepository> toAetherRepos(List<ArtifactRepository> remoteArtifactRepositories) {
        return RepositoryUtils.toRepos(remoteArtifactRepositories);
    }

    public void installArtifact(File repositoryFile, org.apache.maven.artifact.Artifact artifact) throws MojoExecutionException {
        Preconditions.checkArgument((artifact != null ? 1 : 0) != 0, (Object)"Artifact to be installed should not be null");
        String artifactFilename = this.getFormattedFileName(artifact);
        String artifactPomFilename = this.getPomFileName(artifact);
        File artifactFolderDestination = ArtifactInstaller.getFormattedOutputDirectory(repositoryFile, artifact);
        if (!artifactFolderDestination.exists()) {
            artifactFolderDestination.mkdirs();
        }
        File destinationArtifactFile = new File(artifactFolderDestination, artifactFilename);
        File destinationPomFile = new File(artifactFolderDestination, artifactPomFilename);
        try {
            this.log.info((CharSequence)String.format("Adding artifact <%s%s>", "repository", destinationArtifactFile.getAbsolutePath().replaceFirst(Pattern.quote(repositoryFile.getAbsolutePath()), "")));
            FileUtils.copyFile((File)artifact.getFile(), (File)destinationArtifactFile);
            File srcPomFile = new File(artifact.getFile().getParent(), artifactPomFilename);
            if (!srcPomFile.exists()) {
                srcPomFile = new File(artifact.getFile().getParent(), POM_FILE_NAME);
            }
            FileUtils.copyFile((File)srcPomFile, (File)destinationPomFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was a problem while copying the artifact [%s] file [%s] to the destination [%s]", artifact.toString(), artifact.getFile().getAbsolutePath(), destinationArtifactFile.getAbsolutePath()), (Exception)e);
        }
    }

    private String getPomFileName(org.apache.maven.artifact.Artifact artifact) {
        StringBuilder destFileName = this.buildMainPOMFileName(artifact);
        destFileName.append("pom");
        return destFileName.toString();
    }

    protected String getFormattedFileName(org.apache.maven.artifact.Artifact artifact) {
        StringBuilder destFileName = this.buildMainFileName(artifact);
        String extension = new DefaultArtifactHandler(artifact.getType()).getExtension();
        destFileName.append(extension);
        return destFileName.toString();
    }

    private StringBuilder buildMainFileName(org.apache.maven.artifact.Artifact artifact) {
        StringBuilder mainName = new StringBuilder();
        String versionString = "-" + this.getNormalizedVersion(artifact);
        String classifierString = "";
        if (StringUtils.isNotBlank((CharSequence)artifact.getClassifier())) {
            classifierString = "-" + artifact.getClassifier();
        }
        mainName.append(artifact.getArtifactId()).append(versionString);
        mainName.append(classifierString).append(".");
        return mainName;
    }

    private StringBuilder buildMainPOMFileName(org.apache.maven.artifact.Artifact artifact) {
        StringBuilder mainName = new StringBuilder();
        String versionString = "-" + this.getNormalizedVersion(artifact);
        mainName.append(artifact.getArtifactId()).append(versionString);
        mainName.append(".");
        return mainName;
    }

    protected String getNormalizedVersion(org.apache.maven.artifact.Artifact artifact) {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion())) {
            return artifact.getBaseVersion();
        }
        return artifact.getVersion();
    }

    protected static File getFormattedOutputDirectory(File outputDirectory, org.apache.maven.artifact.Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId().replace('.', File.separatorChar)).append(File.separatorChar);
        sb.append(artifact.getArtifactId()).append(File.separatorChar);
        sb.append(artifact.getBaseVersion()).append(File.separatorChar);
        return new File(outputDirectory, sb.toString());
    }

    public void downloadExcludedDependencyToLocalRepository(org.apache.maven.artifact.Artifact artifact) throws MojoExecutionException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)artifact), null));
        for (RemoteRepository repository : this.toAetherRepos(this.remoteRepositories)) {
            collectRequest.addRepository(repository);
        }
        DependencyFilter dependencyFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime", "compile", "provided", "system", "test"});
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, dependencyFilter);
        try {
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
            List results = dependencyResult.getArtifactResults();
            if (results != null && results.size() != 0) {
                Artifact resolved = ((ArtifactResult)results.get(0)).getArtifact();
                artifact.setFile(resolved.getFile());
            }
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Error while resolving dependency " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion(), (Exception)((Object)e));
        }
    }

    public void generateExcludedDependencyMetadata(File repositoryFile, org.apache.maven.artifact.Artifact artifact) throws MojoExecutionException {
        Preconditions.checkArgument((artifact != null ? 1 : 0) != 0, (Object)"Artifact from which metadata is going to be extracted should not be null");
        String pomFileName = this.getPomFileName(artifact);
        File metadataFolderDestination = ArtifactInstaller.getFormattedOutputDirectory(repositoryFile, artifact);
        if (!metadataFolderDestination.exists()) {
            metadataFolderDestination.mkdirs();
        }
        if (artifact.getFile() == null) {
            return;
        }
        File sourcePomFile = new File(artifact.getFile().getParent(), pomFileName);
        if (!sourcePomFile.exists()) {
            sourcePomFile = new File(artifact.getFile().getParent(), POM_FILE_NAME);
        }
        File destinationPomFile = new File(metadataFolderDestination, pomFileName);
        try {
            this.log.info((CharSequence)String.format("Adding artifact <%s%s>", "repository", destinationPomFile.getAbsolutePath().replaceFirst(Pattern.quote(repositoryFile.getAbsolutePath()), "")));
            FileUtils.copyFile((File)sourcePomFile, (File)destinationPomFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was a problem while copying the [%s] pom file from [%s] to the destination [%s]", artifact.toString(), sourcePomFile.getAbsolutePath(), destinationPomFile.getAbsolutePath()), (Exception)e);
        }
    }
}

