/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.agent.AgentDeployer;
import org.mule.tools.client.arm.ArmDeployer;
import org.mule.tools.client.cloudhub.CloudhubDeployer;
import org.mule.tools.client.standalone.ClusterDeployer;
import org.mule.tools.client.standalone.Deployer;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.maven.mojo.AbstractMuleDeployerMojo;
import org.mule.tools.maven.mojo.model.ArtifactDescription;
import org.mule.util.FilenameUtils;

@Mojo(name="deploy", requiresProject=true)
public class DeployMojo
extends AbstractMuleDeployerMojo {
    private static final long DEFAULT_POLLING_DELAY = 1000L;
    private static final Integer MAX_CLUSTER_SIZE = 8;
    @Component
    protected ArchiverManager archiverManager;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.initializeApplication();
        this.initializeEnvironment();
        switch (this.deploymentConfiguration.getDeploymentType()) {
            case standalone: {
                this.standalone();
                break;
            }
            case cluster: {
                this.cluster();
                break;
            }
            case arm: {
                this.arm();
                break;
            }
            case cloudhub: {
                this.cloudhub();
                break;
            }
            case agent: {
                this.agent();
                break;
            }
            default: {
                throw new MojoFailureException("Unsupported deploymentConfiguration type: " + (Object)((Object)this.deploymentConfiguration.getDeploymentType()));
            }
        }
    }

    private void cloudhub() throws MojoFailureException, MojoExecutionException {
        CloudhubDeployer deployer = new CloudhubDeployer(this.deploymentConfiguration.getUri(), this.deploymentConfiguration.getUsername(), this.deploymentConfiguration.getPassword(), this.deploymentConfiguration.getEnvironment(), this.deploymentConfiguration.getApplicationName(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getRegion(), this.deploymentConfiguration.getMuleVersion(), this.deploymentConfiguration.getWorkers(), this.deploymentConfiguration.getWorkerType(), this.getLog(), this.deploymentConfiguration.getProperties(), this.deploymentConfiguration.getBusinessGroup());
        this.deployWithDeployer(deployer);
    }

    private void arm() throws MojoFailureException, MojoExecutionException {
        ArmDeployer deployer = new ArmDeployer(this.deploymentConfiguration.getUri(), this.deploymentConfiguration.getUsername(), this.deploymentConfiguration.getPassword(), this.deploymentConfiguration.getEnvironment(), this.deploymentConfiguration.getTargetType(), this.deploymentConfiguration.getTarget(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getApplicationName(), this.getLog(), this.deploymentConfiguration.getBusinessGroup(), this.deploymentConfiguration.isArmInsecure());
        this.deployWithDeployer(deployer);
    }

    private void agent() throws MojoFailureException, MojoExecutionException {
        AgentDeployer deployer = new AgentDeployer(this.getLog(), this.deploymentConfiguration.getApplicationName(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getUri());
        this.deployWithDeployer(deployer);
    }

    private void deployWithDeployer(AbstractDeployer deployer) throws MojoExecutionException, MojoFailureException {
        if (null != this.deploymentConfiguration.getScript()) {
            this.executeGroovyScript();
        }
        try {
            deployer.deploy();
        }
        catch (DeploymentException e) {
            this.getLog().error((CharSequence)("Failed to deploy " + this.deploymentConfiguration.getApplicationName() + ": " + e.getMessage()), (Throwable)e);
            throw new MojoFailureException("Failed to deploy [" + this.deploymentConfiguration.getApplication() + "]");
        }
    }

    private void cluster() throws MojoExecutionException, MojoFailureException {
        this.validateSize();
        File[] muleHomes = new File[this.deploymentConfiguration.getSize().intValue()];
        LinkedList<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        for (int i = 0; i < this.deploymentConfiguration.getSize(); ++i) {
            File buildDirectory = new File(this.mavenProject.getBuild().getDirectory(), "mule" + i);
            buildDirectory.mkdir();
            File home = this.doInstallMule(buildDirectory);
            controllers.add(new MuleProcessController(home.getAbsolutePath(), this.deploymentConfiguration.getTimeout()));
            muleHomes[i] = home;
        }
        this.renameApplicationToApplicationName();
        if (null != this.deploymentConfiguration.getScript()) {
            this.executeGroovyScript();
        }
        new ClusterDeployer(muleHomes, controllers, this.getLog(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getDeploymentTimeout(), this.deploymentConfiguration.getArguments(), 1000L).addLibraries(this.deploymentConfiguration.getLibs()).execute();
    }

    private void validateSize() throws MojoFailureException {
        if (this.deploymentConfiguration.getSize() > MAX_CLUSTER_SIZE) {
            throw new MojoFailureException("Cannot create cluster with more than 8 nodes");
        }
    }

    public void standalone() throws MojoExecutionException, MojoFailureException {
        File muleHome = this.installMule(new File(this.mavenProject.getBuild().getDirectory()));
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), this.deploymentConfiguration.getTimeout());
        this.renameApplicationToApplicationName();
        Deployer deployer = new Deployer(mule, this.getLog(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getDeploymentTimeout(), this.deploymentConfiguration.getArguments(), 1000L).addLibraries(this.deploymentConfiguration.getLibs());
        this.addDomain(deployer);
        this.addDependencies(deployer);
        if (null != this.deploymentConfiguration.getScript()) {
            this.executeGroovyScript();
        }
        deployer.execute();
    }

    private void renameApplicationToApplicationName() throws MojoFailureException {
        if (!FilenameUtils.getBaseName((String)this.deploymentConfiguration.getApplication().getName()).equals(this.deploymentConfiguration.getApplicationName())) {
            try {
                File destApplication = new File(this.deploymentConfiguration.getApplication().getParentFile(), this.deploymentConfiguration.getApplicationName() + ".zip");
                FileUtils.copyFile((File)this.deploymentConfiguration.getApplication(), (File)destApplication);
                this.deploymentConfiguration.setApplication(destApplication);
            }
            catch (IOException e) {
                throw new MojoFailureException("Couldn't rename [" + this.deploymentConfiguration.getApplication() + "] to [" + this.deploymentConfiguration.getApplicationName() + "]");
            }
        }
    }

    private File installMule(File buildDirectory) throws MojoExecutionException, MojoFailureException {
        if (this.deploymentConfiguration.getMuleHome() == null) {
            this.deploymentConfiguration.setMuleHome(this.doInstallMule(buildDirectory));
        }
        this.mavenProject.getProperties().setProperty("mule.home", this.deploymentConfiguration.getMuleHome().getAbsolutePath());
        this.getLog().info((CharSequence)("Using MULE_HOME: " + this.deploymentConfiguration.getMuleHome()));
        return this.deploymentConfiguration.getMuleHome();
    }

    private File doInstallMule(File buildDirectory) throws MojoExecutionException, MojoFailureException {
        if (this.deploymentConfiguration.getMuleDistribution() == null) {
            if (this.deploymentConfiguration.isCommunity()) {
                this.deploymentConfiguration.setMuleDistribution(new ArtifactDescription("org.mule.distributions", "mule-standalone", this.deploymentConfiguration.getMuleVersion(), "tar.gz"));
                this.getLog().debug((CharSequence)("muleDistribution not set, using default community artifact: " + this.deploymentConfiguration.getMuleDistribution()));
            } else {
                this.deploymentConfiguration.setMuleDistribution(new ArtifactDescription("com.mulesoft.muleesb.distributions", "mule-ee-distribution-standalone", this.deploymentConfiguration.getMuleVersion(), "tar.gz"));
                this.getLog().debug((CharSequence)("muleDistribution not set, using default artifact: " + this.deploymentConfiguration.getMuleDistribution()));
            }
        }
        this.unpackMule(this.deploymentConfiguration.getMuleDistribution(), buildDirectory);
        return new File(buildDirectory, this.deploymentConfiguration.getMuleDistribution().getContentDirectory());
    }

    private void unpackMule(ArtifactDescription muleDistribution, File destDir) throws MojoExecutionException, MojoFailureException {
        File src = this.getDependency(muleDistribution);
        this.getLog().info((CharSequence)("Copying " + src.getAbsolutePath() + " to " + destDir.getAbsolutePath()));
        this.extract(src, destDir, muleDistribution.getType());
    }

    private void extract(File src, File dest, String type) throws MojoExecutionException, MojoFailureException {
        try {
            UnArchiver unArchiver = this.getArchiver(type);
            unArchiver.setSourceFile(src);
            unArchiver.setDestDirectory(dest);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Couldn't extract file " + src + " to " + dest);
        }
        catch (Exception e) {
            throw new MojoFailureException("Couldn't extract file " + src + " to " + dest);
        }
    }

    private UnArchiver getArchiver(String type) throws MojoExecutionException {
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(type);
            this.getLog().debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
            return unArchiver;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Couldn't find archiver for type: " + type);
        }
    }
}

