/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.mule.tools.client.standalone.Deployer;
import org.mule.tools.maven.mojo.model.ArtifactDescription;
import org.mule.tools.maven.mojo.model.DeploymentConfiguration;

public abstract class AbstractMuleDeployerMojo
extends AbstractMojo {
    @Parameter
    protected DeploymentConfiguration deploymentConfiguration;
    @Component
    protected Settings settings;
    @Component
    protected SettingsDecrypter decrypter;
    @Component
    protected MavenProject mavenProject;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isNotEmpty((String)this.deploymentConfiguration.getSkip()) && "true".equals(this.deploymentConfiguration.getSkip())) {
            this.getLog().info((CharSequence)("Skipping execution: skip=" + this.deploymentConfiguration.getSkip()));
        } else {
            this.getLog().debug((CharSequence)("Executing mojo, skip=" + this.deploymentConfiguration.getSkip()));
            this.doExecute();
        }
    }

    protected abstract void doExecute() throws MojoFailureException, MojoExecutionException;

    protected File getDependency(ArtifactDescription artifactDescription) throws MojoExecutionException, MojoFailureException {
        try {
            Artifact artifact = this.artifactFactory.createArtifact(artifactDescription.getGroupId(), artifactDescription.getArtifactId(), artifactDescription.getVersion(), null, artifactDescription.getType());
            this.getLog().info((CharSequence)("Resolving " + artifact));
            this.artifactResolver.resolve(artifact, this.mavenProject.getRemoteArtifactRepositories(), this.localRepository);
            return artifact.getFile();
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoFailureException("Couldn't download artifact: " + e.getMessage());
        }
    }

    protected void addDomain(Deployer deployer) throws MojoFailureException {
        if (this.deploymentConfiguration.getDomain() != null && this.deploymentConfiguration.getDomain().exists()) {
            this.getLog().debug((CharSequence)("Adding domain with configuration: " + this.deploymentConfiguration.getDomain()));
            deployer.addDomain(this.deploymentConfiguration.getDomain());
        } else {
            this.getLog().debug((CharSequence)("Domain configuration not found: " + this.deploymentConfiguration.getDomain()));
        }
    }

    protected String readFile(String file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected void executeGroovyScript() throws MojoExecutionException {
        GroovyShell shell = new GroovyShell();
        this.getLog().info((CharSequence)("executing script: " + this.deploymentConfiguration.getScript().getAbsolutePath()));
        shell.setProperty("basedir", (Object)this.mavenProject.getBasedir());
        for (Map.Entry<Object, Object> entry : this.mavenProject.getProperties().entrySet()) {
            shell.setProperty((String)entry.getKey(), entry.getValue());
        }
        this.getLog().info((CharSequence)this.mavenProject.getBasedir().getAbsolutePath());
        try {
            shell.evaluate(this.readFile(this.deploymentConfiguration.getScript().getAbsolutePath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("error executing script: " + this.deploymentConfiguration.getScript().getAbsolutePath() + "\n" + e.getMessage());
        }
    }

    protected void addDependencies(Deployer deployer) throws MojoFailureException, MojoExecutionException {
        ArrayList<File> libraries = new ArrayList<File>();
        for (ArtifactDescription artifact : this.deploymentConfiguration.getArtifactItems()) {
            libraries.add(this.getDependency(artifact));
        }
        deployer.addLibraries(libraries);
    }

    protected Artifact resolveMavenProjectArtifact() throws MojoFailureException {
        Artifact artifact = this.artifactFactory.createArtifact(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), "", "zip");
        try {
            this.artifactResolver.resolve(artifact, new ArrayList(), this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoFailureException("Couldn't resolve artifact [" + artifact + "]");
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoFailureException("Couldn't resolve artifact [" + artifact + "]");
        }
        return artifact;
    }

    protected void initializeApplication() throws MojoFailureException {
        if (this.deploymentConfiguration.getApplication() == null) {
            Artifact artifact = this.resolveMavenProjectArtifact();
            this.deploymentConfiguration.setApplication(this.resolveMavenProjectArtifact().getFile());
            this.getLog().info((CharSequence)("No application configured. Using project artifact: " + this.deploymentConfiguration.getApplication()));
            if (this.deploymentConfiguration.getApplicationName() == null) {
                this.deploymentConfiguration.setApplicationName(artifact.getArtifactId());
            }
        } else if (this.deploymentConfiguration.getApplicationName() == null) {
            this.deploymentConfiguration.setApplicationName(this.deploymentConfiguration.getApplication().getName());
        }
    }

    protected void initializeEnvironment() throws MojoExecutionException {
        String ibmJdkSupport;
        if (this.deploymentConfiguration.getServer() != null) {
            Server serverObject = this.settings.getServer(this.deploymentConfiguration.getServer());
            if (serverObject == null) {
                this.getLog().error((CharSequence)("Server [" + this.deploymentConfiguration.getServer() + "] not found in settings file."));
                throw new MojoExecutionException("Server [" + this.deploymentConfiguration.getServer() + "] not found in settings file.");
            }
            serverObject = this.decrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(serverObject)).getServer();
            if (StringUtils.isNotEmpty((String)this.deploymentConfiguration.getUsername()) || StringUtils.isNotEmpty((String)this.deploymentConfiguration.getPassword())) {
                this.getLog().warn((CharSequence)"Both server and credentials are configured. Using plugin configuration credentials.");
            } else {
                this.deploymentConfiguration.setUsername(serverObject.getUsername());
                this.deploymentConfiguration.setPassword(serverObject.getPassword());
            }
        }
        if ("true".equals(ibmJdkSupport = System.getProperty("ibm.jdk.support"))) {
            this.getLog().debug((CharSequence)"Attempting to provide support for IBM JDK...");
            try {
                Field methods = HttpURLConnection.class.getDeclaredField("methods");
                methods.setAccessible(true);
                Field modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
                modifiers.setInt(methods, methods.getModifiers() & 0xFFFFFFEF);
                String[] actualMethods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "PATCH", "DELETE", "TRACE"};
                methods.set(null, actualMethods);
            }
            catch (NoSuchFieldException e) {
                this.getLog().error((CharSequence)"Fail to provide support for IBM JDK", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.getLog().error((CharSequence)"Fail to provide support for IBM JDK", (Throwable)e);
            }
        }
    }

    public static enum DeploymentType {
        standalone,
        cluster,
        cloudhub,
        arm,
        agent;

    }
}

