/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.tools.maven.DependencyMapBuilder;

public class MulePluginsCompatibilityValidator {
    private final DependencyMapBuilder dependencyMapBuilder = new DependencyMapBuilder();

    public void validate(List<Dependency> mulePlugins) throws MojoExecutionException {
        for (Map.Entry<String, List<Dependency>> entry : this.dependencyMapBuilder.build(mulePlugins).entrySet()) {
            List<Dependency> dependencies = entry.getValue();
            if (dependencies.size() <= 1 || this.areMulePluginVersionCompatible(dependencies)) continue;
            throw new MojoExecutionException(this.createErrorMessage(entry.getKey(), dependencies));
        }
    }

    private boolean areMulePluginVersionCompatible(List<Dependency> dependencies) {
        Set majors = dependencies.stream().map(Dependency::getVersion).map(v -> v.substring(0, v.indexOf("."))).collect(Collectors.toSet());
        return majors.size() <= 1;
    }

    private String createErrorMessage(String mulePlugin, List<Dependency> dependencies) {
        StringBuilder message = new StringBuilder().append("There are incompatible versions of the same mule plugin in the application dependency graph.").append("This application can not be package as it will fail to deploy.").append("Offending mule plugin: ").append(mulePlugin).append("Versions: ");
        dependencies.forEach(d -> message.append(d.getVersion()).append(","));
        return message.toString();
    }
}

