/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.builder.MulePackageBuilder;
import org.mule.tools.api.packager.builder.PackageBuilder;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PackageMojo
extends AbstractMuleMojo {
    private static final String ZIP_EXTENSION = "zip";
    @Component
    protected MavenProjectHelper helper;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Packaging...");
        String targetFolder = this.project.getBuild().getDirectory();
        File destinationFile = this.getDestinationFile(targetFolder);
        try {
            this.getPackageBuilder().createPackage(Paths.get(targetFolder, new String[0]), destinationFile.toPath());
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)e);
        }
        this.helper.attachArtifact(this.project, ZIP_EXTENSION, this.getClassifier(), destinationFile);
    }

    protected File getDestinationFile(String targetFolder) throws MojoExecutionException {
        Preconditions.checkArgument((targetFolder != null ? 1 : 0) != 0, (Object)"The target folder must not be null");
        Path destinationPath = Paths.get(targetFolder, this.getFileName());
        try {
            Files.deleteIfExists(destinationPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Exception deleting the file [%s]", destinationPath), (Exception)e);
        }
        return destinationPath.toFile();
    }

    protected String getFileName() {
        return this.finalName + "-" + this.getClassifier() + "." + ZIP_EXTENSION;
    }

    protected PackageBuilder getPackageBuilder() {
        return new MulePackageBuilder();
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_PACKAGE_PREVIOUS_RUN_PLACEHOLDER";
    }
}

