/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule.proxy;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

public class ProxyConfiguration {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTP_NO_PROXY = "http.nonProxyHosts";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String HTTPS_PROXY_USER = "https.proxyUser";
    private static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    private static final String PROTOCOL_HTTP = "http";
    protected final Log log;
    protected Settings settings;

    public ProxyConfiguration(Log log, Settings settings) {
        this.log = log;
        this.settings = settings;
    }

    public void handleProxySettings() throws Exception {
        Proxy proxy = this.getProxy(this.settings);
        if (ProxyConfiguration.isProxyValid(proxy)) {
            this.setupProxyProperties(proxy);
            this.setupNonProxyHostsProperties(proxy);
            this.setupProxyCredentials(proxy);
        }
    }

    private void setupProxyCredentials(final Proxy proxy) {
        if (StringUtils.isNotBlank((String)proxy.getUsername())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxy.getUsername(), proxy.getPassword().toCharArray());
                }
            });
            this.log.info((CharSequence)String.format("Proxy settings authentication detected. %s:*****", proxy.getUsername()));
        }
    }

    private void setupNonProxyHostsProperties(Proxy proxy) {
        if (StringUtils.isNotBlank((String)proxy.getNonProxyHosts())) {
            System.setProperty(HTTP_NO_PROXY, proxy.getNonProxyHosts());
        }
    }

    private void setupProxyProperties(Proxy proxy) {
        System.setProperty(HTTP_PROXY_HOST, proxy.getHost());
        System.setProperty(HTTP_PROXY_PORT, String.valueOf(proxy.getPort()));
        System.setProperty(HTTP_PROXY_USER, proxy.getUsername());
        System.setProperty(HTTP_PROXY_PASSWORD, proxy.getPassword());
    }

    private static boolean isProxyValid(Proxy proxy) {
        return proxy != null && StringUtils.isNotBlank((String)proxy.getHost()) && proxy.getPort() > 0;
    }

    private Proxy getProxy(Settings settings) throws Exception {
        if (!StringUtils.isBlank((String)System.getProperty(HTTP_PROXY_HOST))) {
            return this.buildProxyFromProperties(System.getProperty(HTTP_PROXY_HOST), System.getProperty(HTTP_PROXY_PORT), System.getProperty(HTTP_PROXY_USER), System.getProperty(HTTP_PROXY_PASSWORD));
        }
        if (!StringUtils.isBlank((String)System.getProperty(HTTPS_PROXY_HOST))) {
            return this.buildProxyFromProperties(System.getProperty(HTTPS_PROXY_HOST), System.getProperty(HTTPS_PROXY_PORT), System.getProperty(HTTPS_PROXY_USER), System.getProperty(HTTPS_PROXY_PASSWORD));
        }
        return (Proxy)IterableUtils.find((Iterable)settings.getProxies(), (Predicate)new Predicate<Proxy>(){

            public boolean evaluate(Proxy item) {
                return item.isActive() && (ProxyConfiguration.PROTOCOL_HTTP.equalsIgnoreCase(item.getProtocol()) || StringUtils.isBlank((String)item.getProtocol()));
            }
        });
    }

    private Proxy buildProxyFromProperties(String host, String port, String username, String password) throws Exception {
        Proxy proxy = new Proxy();
        proxy.setHost(host);
        proxy.setUsername(username);
        if (!(port != null & password != null)) {
            throw new NoSuchFieldException("Missing proxy configuration.");
        }
        proxy.setPort(Integer.parseInt(port));
        proxy.setPassword(password);
        return proxy;
    }

    public static boolean isAbleToSetupProxy(Settings settings) {
        return !StringUtils.isBlank((String)System.getProperty(HTTP_PROXY_HOST)) || !StringUtils.isBlank((String)System.getProperty(HTTPS_PROXY_HOST)) || settings != null && CollectionUtils.isNotEmpty((Collection)settings.getProxies());
    }
}

