/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.maven.plugin.mule.AbstractApi;
import org.mule.tools.maven.plugin.mule.ApiException;
import org.mule.tools.maven.plugin.mule.arm.AuthorizationResponse;
import org.mule.tools.maven.plugin.mule.arm.Environment;
import org.mule.tools.maven.plugin.mule.arm.Environments;
import org.mule.tools.maven.plugin.mule.arm.Organization;
import org.mule.tools.maven.plugin.mule.arm.User;
import org.mule.tools.maven.plugin.mule.arm.UserInfo;

public abstract class AbstractMuleApi
extends AbstractApi {
    private static final String ME = "/accounts/api/me";
    private static final String ENVIRONMENTS = "/accounts/api/organizations/%s/environments";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ENV_ID_HEADER = "X-ANYPNT-ENV-ID";
    private static final String ORG_ID_HEADER = "X-ANYPNT-ORG-ID";
    public static final String ORGANIZATION = "organization";
    public static final String SUB_ORGANIZATION_IDS = "subOrganizationIds";
    public static final String NAME = "name";
    public static final String USER = "user";
    public static final String ID = "id";
    protected String uri;
    private String username;
    private String password;
    private String environment;
    private final String businessGroup;
    private String bearerToken;
    private String envId;
    private String orgId;

    public AbstractMuleApi(String uri, Log log, String username, String password, String environment, String businessGroup) {
        super(log);
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.environment = environment;
        this.businessGroup = businessGroup;
    }

    public void init() {
        this.bearerToken = this.getBearerToken(this.username, this.password);
        this.orgId = this.getOrgId();
        this.envId = this.findEnvironmentByName((String)this.environment).id;
    }

    private String getBearerToken(String username, String password) {
        Entity json = Entity.json((Object)("{\"username\": \"" + username + "\", \"password\": \"" + password + "\"}"));
        Response response = this.post(this.uri, "/accounts/login", json);
        this.validateStatusSuccess(response);
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)response.readEntity(AuthorizationResponse.class);
        return authorizationResponse.access_token;
    }

    protected void validateStatusSuccess(Response response) {
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ApiException(response);
        }
    }

    public String getOrgId() {
        return this.getBusinessGroupIdByBusinessGroupPath();
    }

    public Environment findEnvironmentByName(String name) {
        Environments response = this.get(this.uri, String.format(ENVIRONMENTS, this.orgId), Environments.class);
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find environment named [" + name + "]");
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header(AUTHORIZATION_HEADER, (Object)("bearer " + this.bearerToken));
        }
        if (this.envId != null && this.orgId != null) {
            builder.header(ENV_ID_HEADER, (Object)this.envId);
            builder.header(ORG_ID_HEADER, (Object)this.orgId);
        }
    }

    public String getBusinessGroupIdByBusinessGroupPath() {
        String currentOrgId = null;
        Organization organizationHierarchy = this.getMe().user.organization;
        if (organizationHierarchy.subOrganizations.isEmpty()) {
            return organizationHierarchy.id;
        }
        List<Organization> subOrganizations = organizationHierarchy.subOrganizations;
        String[] groups = this.createBusinessGroupPath();
        if (groups.length == 0) {
            currentOrgId = organizationHierarchy.id;
        } else {
            block0: for (int group = 0; group < groups.length; ++group) {
                String groupName = groups[group];
                for (Organization o : subOrganizations) {
                    if (!o.name.equals(groupName)) continue;
                    currentOrgId = o.id;
                    subOrganizations = o.subOrganizations;
                    continue block0;
                }
            }
        }
        if (currentOrgId == null) {
            throw new ArrayIndexOutOfBoundsException("Cannot find business group.");
        }
        return currentOrgId;
    }

    public UserInfo getMe() {
        String userInfoJsonString = this.get(this.uri, ME, String.class);
        JsonObject userInfoJson = (JsonObject)new JsonParser().parse(userInfoJsonString);
        Organization organization = this.buildOrganization(userInfoJson);
        User user = new User();
        user.organization = organization;
        UserInfo userInfo = new UserInfo();
        userInfo.user = user;
        return userInfo;
    }

    private Organization buildOrganization(JsonObject userInfoJson) {
        JsonObject organizationJson;
        JsonObject userJson;
        Organization organization = new Organization();
        if (userInfoJson != null && userInfoJson.has(USER) && (userJson = (JsonObject)userInfoJson.get(USER)) != null && userJson.has(ORGANIZATION) && (organizationJson = userJson.getAsJsonObject(ORGANIZATION)).has(ID) && organizationJson.has(NAME)) {
            organization.id = organizationJson.get(ID).getAsString();
            organization.name = organizationJson.get(NAME).getAsString();
            organization.subOrganizations = this.resolveSuborganizations(userJson, organizationJson);
        }
        return organization;
    }

    protected List<Organization> resolveSuborganizations(JsonObject userJson, JsonObject organizationJson) {
        ArrayList<Organization> suborganizations = new ArrayList<Organization>();
        if (organizationJson.has(SUB_ORGANIZATION_IDS)) {
            Set<String> ids = this.getSuborganizationIds(organizationJson);
            suborganizations.addAll(this.resolveAllSuborganizations(ids, userJson, "memberOfOrganizations"));
            suborganizations.addAll(this.resolveAllSuborganizations(ids, userJson, "contributorOfOrganizations"));
        }
        return suborganizations;
    }

    public Set<String> getSuborganizationIds(JsonObject organizationJson) {
        HashSet<String> suborganizationIds = new HashSet<String>();
        JsonArray subOrganizationIds = organizationJson.get(SUB_ORGANIZATION_IDS).getAsJsonArray();
        if (subOrganizationIds != null) {
            for (JsonElement id : subOrganizationIds) {
                suborganizationIds.add(id.getAsString());
            }
        }
        return suborganizationIds;
    }

    private Collection<? extends Organization> resolveAllSuborganizations(Set<String> ids, JsonObject userJson, String organizationsDefinition) {
        JsonArray subOrganizationUserIsMemberOf;
        ArrayList<Organization> suborganizations = new ArrayList<Organization>();
        if (userJson.has(organizationsDefinition) && (subOrganizationUserIsMemberOf = userJson.get(organizationsDefinition).getAsJsonArray()) != null) {
            for (JsonElement org : subOrganizationUserIsMemberOf) {
                if (!org.isJsonObject()) continue;
                Organization suborganization = new Organization();
                suborganization.id = ((JsonObject)org).get(ID).getAsString();
                if (!ids.contains(suborganization.id)) continue;
                suborganization.name = ((JsonObject)org).get(NAME).getAsString();
                suborganizations.add(suborganization);
                ids.remove(suborganization.id);
            }
        }
        return suborganizations;
    }

    protected String[] createBusinessGroupPath() {
        int i;
        if (StringUtils.isEmpty((String)this.businessGroup)) {
            return new String[0];
        }
        ArrayList<String> groups = new ArrayList<String>();
        String group = "";
        for (i = 0; i < this.businessGroup.length() - 1; ++i) {
            if (this.businessGroup.charAt(i) == '\\') {
                if (this.businessGroup.charAt(i + 1) == '\\') {
                    group = group + "\\";
                    ++i;
                    continue;
                }
                groups.add(group);
                group = "";
                continue;
            }
            group = group + this.businessGroup.charAt(i);
        }
        if (i < this.businessGroup.length()) {
            group = group + this.businessGroup.charAt(this.businessGroup.length() - 1);
        }
        groups.add(group);
        return groups.toArray(new String[0]);
    }
}

