/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule.agent;

import java.io.File;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.maven.plugin.mule.AbstractApi;
import org.mule.tools.maven.plugin.mule.ApiException;

public class AgentApi
extends AbstractApi {
    public static final String APPLICATIONS_PATH = "/mule/applications/";
    private final String uri;

    public AgentApi(Log log, String uri) {
        super(log);
        this.uri = uri;
    }

    public void deployApplication(String applicationName, File file) {
        Response response = this.put(this.uri, APPLICATIONS_PATH + applicationName, Entity.entity((Object)file, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
        if (response.getStatus() != 202) {
            throw new ApiException(response, this.uri + APPLICATIONS_PATH + applicationName);
        }
    }

    public void undeployApplication(String appName) {
        Response response = this.delete(this.uri, APPLICATIONS_PATH + appName);
        if (response.getStatus() != 202) {
            throw new ApiException(response, this.uri + APPLICATIONS_PATH + appName);
        }
    }
}

