/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import java.io.File;
import javax.ws.rs.NotFoundException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.maven.plugin.mule.AbstractMuleMojo;
import org.mule.tools.maven.plugin.mule.Undeployer;
import org.mule.tools.maven.plugin.mule.agent.AgentApi;
import org.mule.tools.maven.plugin.mule.arm.ArmApi;
import org.mule.tools.maven.plugin.mule.cloudhub.CloudhubApi;

@Mojo(name="undeploy", requiresProject=true)
public class UndeployMojo
extends AbstractMuleMojo {
    @Parameter(defaultValue="true")
    private boolean failIfNotExists;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.initializeApplication();
        this.initializeEnvironment();
        switch (this.deploymentType) {
            case standalone: {
                this.standalone();
                break;
            }
            case cluster: {
                this.cluster();
                break;
            }
            case arm: {
                this.arm();
                break;
            }
            case cloudhub: {
                this.cloudhub();
                break;
            }
            case agent: {
                this.agent();
                break;
            }
            default: {
                throw new MojoFailureException("Unsupported deployment type: " + (Object)((Object)this.deploymentType));
            }
        }
    }

    private void cloudhub() throws MojoFailureException {
        CloudhubApi cloudhubApi = new CloudhubApi(this.uri, this.getLog(), this.username, this.password, this.environment, this.businessGroup);
        cloudhubApi.init();
        this.getLog().info((CharSequence)("Stopping application " + this.applicationName));
        cloudhubApi.stopApplication(this.applicationName);
    }

    private void arm() throws MojoFailureException {
        ArmApi armApi = new ArmApi(this.getLog(), this.uri, this.username, this.password, this.environment, this.businessGroup, this.armInsecure);
        armApi.init();
        this.getLog().info((CharSequence)("Undeploying application " + this.applicationName));
        try {
            armApi.undeployApplication(this.applicationName, this.targetType, this.target);
        }
        catch (NotFoundException e) {
            if (this.failIfNotExists) {
                throw e;
            }
            this.getLog().warn((CharSequence)("Application not found: " + this.applicationName));
        }
    }

    private void agent() throws MojoFailureException {
        AgentApi agentApi = new AgentApi(this.getLog(), this.uri);
        this.getLog().info((CharSequence)("Undeploying application " + this.applicationName));
        agentApi.undeployApplication(this.applicationName);
    }

    private void cluster() throws MojoFailureException, MojoExecutionException {
        File[] muleHomes = new File[this.size.intValue()];
        for (int i = 0; i < this.size; ++i) {
            File parentDir = new File(this.mavenProject.getBuild().getDirectory(), "mule" + i);
            muleHomes[i] = new File(parentDir, "mule-enterprise-standalone-" + this.muleVersion);
            if (muleHomes[i].exists()) continue;
            throw new MojoFailureException(muleHomes[i].getAbsolutePath() + "directory does not exist.");
        }
        new Undeployer(this.getLog(), this.applicationName, muleHomes).execute();
    }

    public void standalone() throws MojoFailureException, MojoExecutionException {
        if (!this.muleHome.exists()) {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        this.getLog().info((CharSequence)("Using MULE_HOME: " + this.muleHome));
        new Undeployer(this.getLog(), this.applicationName, this.muleHome).execute();
    }
}

