/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

public class ProxyUtils {
    private static final String SP_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String SP_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String SP_HTTP_NO_PROXY = "http.nonProxyHosts";
    private static final String SP_HTTP_PROXY_USER = "http.proxyUser";
    private static final String SP_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String PROTOCOL_HTTP = "http";

    public static void handleProxyConfigurjation(Settings settings, Log logger) {
        if (ProxyUtils.isAbleToSetupProxy(settings)) {
            ProxyUtils.setupProxy(settings, logger);
        } else {
            logger.info((CharSequence)String.format("Using system properties proxy configuration: %s:%s. no proxy: %s", System.getProperty(SP_HTTP_PROXY_HOST), System.getProperty(SP_HTTP_PROXY_PORT), System.getProperty(SP_HTTP_NO_PROXY)));
        }
    }

    private static void setupProxy(Settings settings, Log logger) {
        Proxy proxy = ProxyUtils.getProxy(settings);
        if (ProxyUtils.isProxyValid(proxy)) {
            ProxyUtils.setupProxyProperties(logger, proxy);
            ProxyUtils.setupNonProxyHostsProperties(logger, proxy);
            ProxyUtils.setupProxyCredentials(logger, proxy);
        }
    }

    private static void setupProxyCredentials(Log logger, final Proxy proxy) {
        if (StringUtils.isNotBlank((CharSequence)proxy.getUsername())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxy.getUsername(), proxy.getPassword().toCharArray());
                }
            });
            logger.info((CharSequence)String.format("Proxy settings authentication detected. %s:*****", proxy.getUsername()));
        }
    }

    private static void setupNonProxyHostsProperties(Log logger, Proxy proxy) {
        if (StringUtils.isNotBlank((CharSequence)proxy.getNonProxyHosts())) {
            System.setProperty(SP_HTTP_NO_PROXY, proxy.getNonProxyHosts());
            logger.info((CharSequence)String.format("No proxy:  %s", proxy.getNonProxyHosts()));
        }
    }

    private static void setupProxyProperties(Log logger, Proxy proxy) {
        System.setProperty(SP_HTTP_PROXY_HOST, proxy.getHost());
        System.setProperty(SP_HTTP_PROXY_PORT, String.valueOf(proxy.getPort()));
        logger.info((CharSequence)String.format("Proxy settings detected:  %s:%s", proxy.getHost(), proxy.getPort()));
    }

    private static boolean isProxyValid(Proxy proxy) {
        return proxy != null && StringUtils.isNotBlank((CharSequence)proxy.getHost()) && proxy.getPort() > 0;
    }

    private static Proxy getProxy(Settings settings) {
        return (Proxy)IterableUtils.find((Iterable)settings.getProxies(), (Predicate)new Predicate<Proxy>(){

            public boolean evaluate(Proxy item) {
                return item.isActive() && (ProxyUtils.PROTOCOL_HTTP.equalsIgnoreCase(item.getProtocol()) || StringUtils.isBlank((CharSequence)item.getProtocol()));
            }
        });
    }

    private static boolean isAbleToSetupProxy(Settings settings) {
        return settings != null && StringUtils.isBlank((CharSequence)System.getProperty(SP_HTTP_PROXY_HOST)) && CollectionUtils.isNotEmpty((Collection)settings.getProxies());
    }
}

