/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.test.infrastructure.process.AppDeploymentProbe;
import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.maven.plugin.mule.ClusterConfigurator;

public class ClusterDeployer {
    private List<MuleProcessController> mules;
    private File[] paths;
    private Log log;
    private File application;
    private Prober prober;
    private long timeout;
    private long pollingDelay;
    private String[] arguments;
    private ClusterConfigurator configurator = new ClusterConfigurator();

    public ClusterDeployer(File[] paths, List<MuleProcessController> mules, Log log, File application, long timeout, String[] arguments, long pollingDelay) {
        this.mules = mules;
        this.log = log;
        this.application = application;
        this.timeout = timeout;
        this.pollingDelay = pollingDelay;
        this.arguments = arguments;
        this.prober = new PollingProber(timeout, pollingDelay);
        this.paths = paths;
        log.debug((CharSequence)this.toString());
    }

    public String toString() {
        return String.format("Deployer with [Controllers=%s, log=%s, application=%s, timeout=%d, pollingDelay=%d ]", this.mules, this.log, this.application, this.timeout, this.pollingDelay);
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        try {
            this.configurator.configureCluster(this.paths, this.mules);
            this.startMulesIfStopped();
            this.deployApplications();
            this.waitForDeployments();
        }
        catch (MuleControllerException e) {
            throw new MojoFailureException("Error deploying application: [" + this.application + "]");
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Unexpected error deploying application: [" + this.application + "]", (Exception)e);
        }
    }

    private void waitForDeployments() throws MojoFailureException {
        for (MuleProcessController m : this.mules) {
            if (!this.application.exists()) {
                throw new MojoFailureException("Application does not exists: " + this.application);
            }
            this.log.debug((CharSequence)("Checking for application [" + this.application + "] to be deployed."));
            String app = this.getApplicationName(this.application);
            try {
                this.prober.check((Probe)AppDeploymentProbe.isDeployed((MuleProcessController)m, (String)app));
            }
            catch (AssertionError e) {
                this.log.error((CharSequence)("Couldn't deploy application [" + this.application + "] after [" + this.timeout + "] miliseconds. Check Mule Runtime log"));
                throw new MojoFailureException("Application deployment timeout.");
            }
        }
    }

    private String getApplicationName(File application) {
        String name = application.getName();
        int extensionBeginning = name.lastIndexOf(46);
        return extensionBeginning == -1 ? name : name.substring(0, extensionBeginning);
    }

    private void deployApplications() throws MojoFailureException {
        for (MuleProcessController m : this.mules) {
            if (!this.application.exists()) {
                throw new MojoFailureException("Application does not exists: " + this.application.getAbsolutePath());
            }
            this.log.info((CharSequence)("Deploying application [" + this.application + "]"));
            try {
                m.deploy(this.application.getAbsolutePath());
            }
            catch (MuleControllerException e) {
                this.log.error((CharSequence)("Couldn't deploy application: " + this.application + ". Check Mule Runtime logs"));
            }
        }
    }

    private void startMulesIfStopped() {
        for (MuleProcessController m : this.mules) {
            this.log.debug((CharSequence)"Checking if Mule Runtime is running.");
            if (m.isRunning()) continue;
            try {
                this.log.info((CharSequence)"Starting Mule Runtime");
                if (this.arguments == null) {
                    m.start(new String[0]);
                    continue;
                }
                m.start(this.arguments);
            }
            catch (MuleControllerException e) {
                this.log.error((CharSequence)"Couldn't start Mule Runtime. Check Mule Runtime logs");
            }
        }
    }

    public ClusterDeployer addLibraries(List<File> libs) {
        for (File file : libs) {
            for (MuleProcessController c : this.mules) {
                c.addLibrary(file);
            }
            this.log.debug((CharSequence)String.format("Adding library %s...", file));
        }
        return this;
    }
}

