/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule.arm;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.maven.plugin.mule.AbstractDeployer;
import org.mule.tools.maven.plugin.mule.ApiException;
import org.mule.tools.maven.plugin.mule.DeploymentException;
import org.mule.tools.maven.plugin.mule.TargetType;
import org.mule.tools.maven.plugin.mule.arm.Application;
import org.mule.tools.maven.plugin.mule.arm.ArmApi;

public class ArmDeployer
extends AbstractDeployer {
    private static final int DEFAULT_UNDEPLOY_TIMEOUT = 60000;
    private static final String TIMEOUT_PROPERTY = System.getProperty("mule.undeploy.TIMEOUT");
    private static final long TIMEOUT = TIMEOUT_PROPERTY == null ? 60000L : Long.parseLong(TIMEOUT_PROPERTY);
    private final TargetType targetType;
    private final String target;
    private final ArmApi armApi;

    public ArmDeployer(String uri, String username, String password, String environment, TargetType targetType, String target, File application, String applicationName, Log log, String businessGroup, boolean armInsecure) {
        super(applicationName, application, log);
        this.targetType = targetType;
        this.target = target;
        this.armApi = new ArmApi(log, uri, username, password, environment, businessGroup, armInsecure);
    }

    @Override
    public void deploy() throws DeploymentException {
        try {
            this.armApi.init();
            this.info("Deploying application " + this.getApplicationName());
            Integer applicationId = this.armApi.findApplication(this.getApplicationName());
            if (applicationId == null) {
                this.armApi.deployApplication(this.getApplicationFile(), this.getApplicationName(), this.targetType, this.target);
            } else {
                String status;
                this.info("Found application " + this.getApplicationName() + ". Undeploying application...");
                long start = System.currentTimeMillis();
                this.armApi.undeployApplication(applicationId);
                Application application = this.armApi.getApplicationStatus(applicationId);
                String string = status = application.data == null ? "UNDEPLOYED" : application.data.lastReportedStatus;
                while (!"UNDEPLOYED".equals(status)) {
                    application = this.armApi.getApplicationStatus(applicationId);
                    String string2 = status = application.data == null ? "UNDEPLOYED" : application.data.lastReportedStatus;
                    if (System.currentTimeMillis() <= start + TIMEOUT) continue;
                    throw new DeploymentException("Failed to undeploy application");
                }
                this.info("Deploying application... ");
                this.armApi.deployApplication(this.getApplicationFile(), this.getApplicationName(), this.targetType, this.target);
            }
        }
        catch (ApiException e) {
            this.error("Failed: " + e.getMessage());
            throw new DeploymentException("Failed to deploy application " + this.getApplicationName(), e);
        }
    }
}

