/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.maven.plugin.logging.Log;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class ApiLoggingFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    private static final String REQUEST_LOGGING_STREAM = "requestLoggingStream";
    private Log log;

    public ApiLoggingFilter(Log log) {
        this.log = log;
    }

    private void appendHeaders(StringBuilder b, MultivaluedMap<String, String> headers) {
        for (Map.Entry headerEntry : headers.entrySet()) {
            b.append((String)headerEntry.getKey()).append(": ").append(StringUtils.join((Collection)((Collection)headerEntry.getValue()), (String)", ")).append("\n");
        }
        b.append("\n");
    }

    public void filter(ClientRequestContext context) throws IOException {
        StringBuilder request = new StringBuilder();
        request.append("HTTP Request\n");
        request.append(context.getMethod() + " " + context.getUri() + "\n");
        this.appendHeaders(request, (MultivaluedMap<String, String>)context.getStringHeaders());
        if (context.hasEntity()) {
            RequestLoggingStream stream = new RequestLoggingStream(request, context.getEntityStream());
            context.setEntityStream((OutputStream)stream);
            context.setProperty(REQUEST_LOGGING_STREAM, (Object)stream);
        } else {
            this.log.debug((CharSequence)request.toString());
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        StringBuilder response = new StringBuilder();
        response.append("HTTP response\n");
        response.append(Integer.toString(responseContext.getStatus())).append(" ").append(responseContext.getStatusInfo().getReasonPhrase()).append("\n");
        this.appendHeaders(response, (MultivaluedMap<String, String>)responseContext.getHeaders());
        if (responseContext.hasEntity()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)responseContext.getEntityStream(), (OutputStream)stream);
            byte[] responseBytes = stream.toByteArray();
            response.append(new String(responseBytes));
            response.append("\n");
            responseContext.setEntityStream((InputStream)new ByteArrayInputStream(responseBytes));
        }
        this.log.debug((CharSequence)response.toString());
    }

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
        RequestLoggingStream stream = (RequestLoggingStream)writerInterceptorContext.getProperty(REQUEST_LOGGING_STREAM);
        writerInterceptorContext.proceed();
        if (stream != null) {
            this.log.debug((CharSequence)stream.getRequestLog());
        }
    }

    private class RequestLoggingStream
    extends FilterOutputStream {
        private StringBuilder request;
        private ByteArrayOutputStream requestBody;

        RequestLoggingStream(StringBuilder request, OutputStream inner) {
            super(inner);
            this.requestBody = new ByteArrayOutputStream();
            this.request = request;
        }

        @Override
        public void write(int i) throws IOException {
            this.requestBody.write(i);
            this.out.write(i);
        }

        public String getRequestLog() {
            this.request.append(new String(this.requestBody.toByteArray()));
            this.request.append('\n');
            return this.request.toString();
        }
    }
}

