/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.mule.tools.maven.plugin.mule.ApiLoggingFilter;

public abstract class AbstractApi {
    protected final Log log;

    public AbstractApi(Log log) {
        this.log = log;
    }

    protected WebTarget getTarget(String uri, String path) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        this.configureSecurityContext(builder);
        Client client = (Client)builder.build().register(MultiPartFeature.class);
        if (this.log != null && this.log.isDebugEnabled()) {
            client.register((Object)new ApiLoggingFilter(this.log));
        }
        return client.target(uri).path(path);
    }

    protected void configureSecurityContext(ClientBuilder builder) {
    }

    protected Response post(String uri, String path, Entity entity) {
        return this.builder(uri, path).post(entity);
    }

    protected Response post(String uri, String path, Object entity) {
        return this.post(uri, path, Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response put(String uri, String path, Entity entity) {
        return this.builder(uri, path).put(entity);
    }

    protected Response put(String uri, String path, Object entity) {
        return this.put(uri, path, Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response delete(String uri, String path) {
        return this.builder(uri, path).delete();
    }

    protected Response get(String uri, String path) {
        return this.builder(uri, path).get();
    }

    protected <T> T get(String uri, String path, Class<T> clazz) {
        return (T)this.get(uri, path).readEntity(clazz);
    }

    private Invocation.Builder builder(String uri, String path) {
        WebTarget target = this.getTarget(uri, path);
        Invocation.Builder builder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        this.configureRequest(builder);
        return builder;
    }

    protected void configureRequest(Invocation.Builder builder) {
    }
}

