/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule.cloudhub;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.maven.plugin.mule.AbstractDeployer;
import org.mule.tools.maven.plugin.mule.ApiException;
import org.mule.tools.maven.plugin.mule.DeploymentException;
import org.mule.tools.maven.plugin.mule.cloudhub.Application;
import org.mule.tools.maven.plugin.mule.cloudhub.CloudhubApi;

public class CloudhubDeployer
extends AbstractDeployer {
    private final CloudhubApi cloudhubApi;
    private final String region;
    private final String muleVersion;
    private final Integer workers;
    private final String workerType;
    private final Map<String, String> properties;

    public CloudhubDeployer(String username, String password, String environment, String applicationName, File application, String region, String muleVersion, Integer workers, String workerType, Log log, Map<String, String> properties) {
        super(applicationName, application, log);
        this.cloudhubApi = new CloudhubApi(log, username, password, environment);
        this.region = region;
        this.muleVersion = muleVersion;
        this.workers = workers;
        this.workerType = workerType;
        this.properties = properties;
    }

    @Override
    public void deploy() throws DeploymentException {
        this.cloudhubApi.init();
        this.info("Deploying application " + this.getApplicationName() + " to Cloudhub");
        if (!this.getApplicationFile().exists()) {
            throw new DeploymentException("Application file " + this.getApplicationFile() + " does not exist.");
        }
        try {
            boolean domainAvailable = this.cloudhubApi.isNameAvailable(this.getApplicationName());
            if (domainAvailable) {
                this.info("Creating application " + this.getApplicationName());
                this.cloudhubApi.createApplication(this.getApplicationName(), this.region, this.muleVersion, this.workers, this.workerType, this.properties);
            } else {
                Application app = this.findApplicationFromCurrentUser(this.getApplicationName());
                if (app != null) {
                    this.info("Application " + this.getApplicationName() + " already exists, redeploying");
                    String updateRegion = this.region == null ? app.region : this.region;
                    String updateMuleVersion = this.muleVersion == null ? app.muleVersion : this.muleVersion;
                    Integer updateWorkers = this.workers == null ? app.workers : this.workers;
                    String updateWorkerType = this.workerType == null ? app.workerType : this.workerType;
                    this.cloudhubApi.updateApplication(this.getApplicationName(), updateRegion, updateMuleVersion, updateWorkers, updateWorkerType, this.properties);
                } else {
                    this.error("Domain " + this.getApplicationName() + " is not available. Aborting.");
                    throw new DeploymentException("Domain " + this.getApplicationName() + " is not available. Aborting.");
                }
            }
            this.info("Uploading application contents " + this.getApplicationName());
            this.cloudhubApi.uploadFile(this.getApplicationName(), this.getApplicationFile());
            this.info("Starting application " + this.getApplicationName());
            this.cloudhubApi.startApplication(this.getApplicationName());
        }
        catch (ApiException e) {
            this.error("Failed: " + e.getMessage());
            throw new DeploymentException("Failed to deploy application " + this.getApplicationName(), e);
        }
    }

    private Application findApplicationFromCurrentUser(String appName) {
        for (Application app : this.cloudhubApi.getApplications()) {
            if (!appName.equals(app.domain)) continue;
            return app;
        }
        return null;
    }
}

