/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule.arm;

import java.io.File;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.tools.maven.plugin.mule.AbstractMuleApi;
import org.mule.tools.maven.plugin.mule.TargetType;
import org.mule.tools.maven.plugin.mule.arm.Application;
import org.mule.tools.maven.plugin.mule.arm.Applications;
import org.mule.tools.maven.plugin.mule.arm.Data;
import org.mule.tools.maven.plugin.mule.arm.Target;
import org.mule.tools.maven.plugin.mule.arm.Targets;

public class ArmApi
extends AbstractMuleApi {
    private static final String APPLICATIONS = "/hybrid/api/v1/applications";
    private static final String SERVERS = "/hybrid/api/v1/servers";
    private static final String SERVER_GROUPS = "/hybrid/api/v1/serverGroups";
    private static final String CLUSTERS = "/hybrid/api/v1/clusters";
    private String uri;

    public ArmApi(Log log, String uri, String username, String password, String environment) {
        super(log, username, password, environment);
        this.uri = uri;
    }

    public Boolean isStarted(int applicationId) {
        Application application = this.getApplicationStatus(applicationId);
        return "STARTED".equals(application.data.lastReportedStatus);
    }

    public Application getApplicationStatus(int applicationId) {
        return this.get(this.uri, "/hybrid/api/v1/applications/" + applicationId, Application.class);
    }

    public String undeployApplication(int applicationId) {
        Response response = this.delete(this.uri, "/hybrid/api/v1/applications/" + applicationId);
        return (String)response.readEntity(String.class);
    }

    public Application deployApplication(File app, String appName, TargetType targetType, String target) {
        String id = this.getId(targetType, target);
        FileDataBodyPart applicationPart = new FileDataBodyPart("file", app);
        MultiPart multipart = new FormDataMultiPart().field("artifactName", appName).field("targetId", id).bodyPart((BodyPart)applicationPart);
        Response response = this.post(this.uri, APPLICATIONS, Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        this.validateStatusSuccess(response);
        return (Application)response.readEntity(Application.class);
    }

    private String getId(TargetType targetType, String target) {
        String id = null;
        switch (targetType) {
            case server: {
                id = this.findServerByName((String)target).id;
                break;
            }
            case serverGroup: {
                id = this.findServerGroupByName((String)target).id;
                break;
            }
            case cluster: {
                id = this.findClusterByName((String)target).id;
            }
        }
        return id;
    }

    public Applications getApplications() {
        return this.get(this.uri, APPLICATIONS, Applications.class);
    }

    public Target findServerByName(String name) {
        return this.findTargetByName(name, SERVERS);
    }

    public Target findServerGroupByName(String name) {
        return this.findTargetByName(name, SERVER_GROUPS);
    }

    public Target findClusterByName(String name) {
        return this.findTargetByName(name, CLUSTERS);
    }

    private Target findTargetByName(String name, String path) {
        Targets response = this.get(this.uri, path, Targets.class);
        if (response.data == null) {
            throw new RuntimeException("Couldn't find target named [" + name + "]");
        }
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find target named [" + name + "]");
    }

    public Integer findApplication(String name) {
        Data[] applications = this.getApplications().data;
        if (applications == null) {
            return null;
        }
        for (int i = 0; i < applications.length; ++i) {
            if (!name.equals(applications[i].artifact.name)) continue;
            return applications[i].id;
        }
        return null;
    }
}

