/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingClassLoaderModelLoader
implements ClassLoaderModelLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolingClassLoaderModelLoader.class);
    private List<ClassLoaderModelLoader> classLoaderModelLoaders;

    public ToolingClassLoaderModelLoader(List<ClassLoaderModelLoader> classLoaderModelLoaders) {
        this.classLoaderModelLoaders = classLoaderModelLoaders;
    }

    public String getId() {
        return "mule";
    }

    public ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        long startTime = System.nanoTime();
        for (ClassLoaderModelLoader classLoaderModelLoader : this.classLoaderModelLoaders) {
            if (!classLoaderModelLoader.supportsArtifactType(artifactType)) continue;
            ClassLoaderModel classLoaderModel = (ClassLoaderModel)classLoaderModelLoader.load(artifactFile, attributes, artifactType);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("ClassLoaderModel for {} loaded in {}ms", (Object)artifactFile.getName(), (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            return classLoaderModel;
        }
        throw new IllegalStateException(String.format("Artifact type %s not supported", artifactType));
    }

    public boolean supportsArtifactType(ArtifactType artifactType) {
        return this.classLoaderModelLoaders.stream().filter(classLoaderModelLoader -> classLoaderModelLoader.supportsArtifactType(artifactType)).findFirst().isPresent();
    }
}

