/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation;

import com.google.common.collect.Lists;
import com.vdurmont.semver4j.SemverException;
import java.util.Collection;
import java.util.List;
import org.mule.tools.utils.VersionUtils;

public class EnvironmentSupportedVersions {
    private final List<String> environmentSupportedVersions;

    public EnvironmentSupportedVersions(Collection<String> environmentSupportedVersions) {
        this.environmentSupportedVersions = Lists.newArrayList(environmentSupportedVersions);
    }

    public EnvironmentSupportedVersions(String environmentVersion) {
        this.environmentSupportedVersions = Lists.newArrayList((Object[])new String[]{environmentVersion});
    }

    public List<String> getEnvironmentSupportedVersions() {
        return this.environmentSupportedVersions;
    }

    public boolean supports(String muleVersion) {
        try {
            return this.environmentSupportedVersions.stream().anyMatch(v -> VersionUtils.isSameVersion(v, muleVersion));
        }
        catch (SemverException semverException) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EnvironmentSupportedVersions that = (EnvironmentSupportedVersions)other;
        return this.environmentSupportedVersions.equals(that.environmentSupportedVersions);
    }

    public int hashCode() {
        return this.environmentSupportedVersions.hashCode();
    }
}

