/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment;

import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.deployment.AbstractDeployerFactory;
import org.mule.tools.deployment.Deployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.utils.DeployerLog;

public class DefaultDeployer
implements Deployer {
    private final Deployer deployer;
    private final DeployerLog log;
    private final String applicationName;

    public DefaultDeployer(Deployment deployment, DeployerLog log) throws DeploymentException {
        this(AbstractDeployerFactory.getDeployerFactory(deployment).createArtifactDeployer(deployment, log), deployment.getApplicationName(), log);
    }

    public DefaultDeployer(Deployer deployer, String applicationName, DeployerLog log) {
        this.deployer = deployer;
        this.applicationName = applicationName;
        this.log = log;
    }

    @Override
    public void deploy() throws DeploymentException {
        this.log.info(String.format("Deploying artifact %s", this.applicationName));
        this.deployer.deploy();
        this.log.info(String.format("Artifact %s deployed", this.applicationName));
    }

    @Override
    public void undeploy() throws DeploymentException {
        this.log.info(String.format("Undeploying artifact %s", this.applicationName));
        this.deployer.undeploy();
        this.log.info(String.format("Artifact %s undeployed", this.applicationName));
    }
}

