/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.agent;

import java.io.File;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tools.client.agent.AgentInfo;
import org.mule.tools.client.agent.model.Application;
import org.mule.tools.client.core.AbstractClient;
import org.mule.tools.client.core.exception.ClientException;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.utils.DeployerLog;

public class AgentClient
extends AbstractClient {
    public static final String APPLICATIONS_PATH = "/mule/applications/";
    public static final String DOMAINS_PATH = "/mule/domains/";
    public static final int ACCEPTED = 202;
    private static final String AGENT_INFO_PATH = "/mule/agent";
    private final String uri;

    public AgentClient(DeployerLog log, Deployment deployment) {
        super(log);
        this.uri = ((AgentDeployment)deployment).getUri();
    }

    @Override
    protected void init() {
    }

    public void deployApplication(String applicationName, File file) {
        this.deployArtifact(applicationName, file, APPLICATIONS_PATH);
    }

    public void deployDomain(String domainName, File file) {
        this.deployArtifact(domainName, file, DOMAINS_PATH);
    }

    protected void deployArtifact(String artifactName, File file, String resourcePath) {
        Entity entity = Entity.entity((Object)file, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Response response = this.put(this.uri, resourcePath + artifactName, entity);
        if (response.getStatus() != 202) {
            throw new ClientException(response, this.uri + resourcePath + artifactName);
        }
    }

    public void undeployApplication(String appName) {
        this.undeployArtifact(appName, APPLICATIONS_PATH);
    }

    public void undeployDomain(String domainName) {
        this.undeployArtifact(domainName, DOMAINS_PATH);
    }

    protected void undeployArtifact(String artifactName, String resourcePath) {
        Response response = this.delete(this.uri, resourcePath + artifactName);
        if (response.getStatus() != 202) {
            throw new ClientException(response, this.uri + resourcePath + artifactName);
        }
    }

    public Application getApplication(String appName) {
        return this.readEntityWithTimeout(() -> (Application)this.get(this.uri, APPLICATIONS_PATH + appName).readEntity(Application.class));
    }

    public AgentInfo getAgentInfo() {
        return this.readEntityWithTimeout(() -> (AgentInfo)this.get(this.uri, AGENT_INFO_PATH).readEntity(AgentInfo.class));
    }
}

