/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.fabric;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.fabric.RuntimeFabricClient;
import org.mule.tools.client.fabric.model.ApplicationModify;
import org.mule.tools.client.fabric.model.ApplicationRequest;
import org.mule.tools.client.fabric.model.AssetReference;
import org.mule.tools.client.fabric.model.DeploymentGenericResponse;
import org.mule.tools.client.fabric.model.DeploymentModify;
import org.mule.tools.client.fabric.model.DeploymentRequest;
import org.mule.tools.client.fabric.model.Deployments;
import org.mule.tools.client.fabric.model.Target;
import org.mule.tools.model.anypoint.Runtime;
import org.mule.tools.model.anypoint.RuntimeFabricDeployment;
import org.mule.tools.model.anypoint.RuntimeFabricDeploymentSettings;
import org.mule.tools.model.anypoint.RuntimeFabricOnPremiseDeploymentSettings;

public class RequestBuilder {
    public static final String ID = "id";
    protected RuntimeFabricDeployment deployment;
    protected RuntimeFabricClient client;
    private static final String AGENT_INFO = "agentInfo";
    private static final String NAME = "name";
    private static final String DOMAIN_WILDCARD = "*";

    public RequestBuilder() {
    }

    public RequestBuilder(RuntimeFabricDeployment deployment, RuntimeFabricClient client) {
        this.deployment = deployment;
        this.client = client;
    }

    public DeploymentRequest buildDeploymentRequest() throws DeploymentException {
        ApplicationRequest applicationRequest = this.buildApplicationRequest();
        Target target = this.buildTarget();
        DeploymentRequest deploymentRequest = new DeploymentRequest();
        deploymentRequest.setName(this.deployment.getApplicationName());
        deploymentRequest.setApplication(applicationRequest);
        deploymentRequest.setTarget(target);
        HashMap applicationPropertiesService = new HashMap();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("properties", this.deployment.getProperties());
        properties.put("secureProperties", this.deployment.getSecureProperties());
        properties.put("applicationName", this.deployment.getApplicationName());
        applicationPropertiesService.put("mule.agent.application.properties.service", properties);
        applicationRequest.setConfiguration(applicationPropertiesService);
        return deploymentRequest;
    }

    public Target buildTarget() throws DeploymentException {
        Target target = new Target();
        target.setProvider(this.deployment.getProvider());
        target.setTargetId(this.resolveTargetId());
        target.setReplicas(this.deployment.getReplicas());
        RuntimeFabricDeploymentSettings resolvedDeploymentSettings = this.resolveDeploymentSettings(this.deployment.getDeploymentSettings());
        target.setDeploymentSettings(resolvedDeploymentSettings);
        return target;
    }

    protected RuntimeFabricDeploymentSettings resolveDeploymentSettings(RuntimeFabricDeploymentSettings settings) throws DeploymentException {
        RuntimeFabricOnPremiseDeploymentSettings resolvedDeploymentSettings = new RuntimeFabricOnPremiseDeploymentSettings((RuntimeFabricOnPremiseDeploymentSettings)settings);
        String targetId = this.resolveTargetId();
        if (Stream.of(this.deployment.getMuleVersion(), this.deployment.getJavaVersion(), this.deployment.getReleaseChannel()).anyMatch(Optional::isPresent)) {
            Runtime runtime = new Runtime();
            this.deployment.getMuleVersion().ifPresent(runtime::setVersion);
            this.deployment.getJavaVersion().ifPresent(runtime::setJava);
            this.deployment.getReleaseChannel().ifPresent(runtime::setReleaseChannel);
            resolvedDeploymentSettings.setRuntime(runtime);
        }
        this.deployment.getMuleVersion().ifPresent(resolvedDeploymentSettings::setRuntimeVersion);
        String url = this.resolveUrl(settings, targetId);
        resolvedDeploymentSettings.getHttp().getInbound().setPublicUrl(url);
        return resolvedDeploymentSettings;
    }

    protected String resolveUrl(RuntimeFabricDeploymentSettings deploymentSettings, String targetId) {
        JsonArray domains = this.client.getDomainInfo(targetId);
        if (deploymentSettings.getHttp().getInbound().getPublicUrl() == null && domains.size() > 0) {
            String domain = domains.get(0).getAsString();
            return domain.replace(DOMAIN_WILDCARD, this.deployment.getApplicationName());
        }
        return deploymentSettings.getHttp().getInbound().getPublicUrl();
    }

    protected String resolveTag(String targetId, String muleVersion) {
        JsonObject targetInfo = this.client.getTargetInfo(targetId);
        if (targetInfo.has("runtimes")) {
            JsonArray runtimes = targetInfo.getAsJsonArray("runtimes");
            return this.getTag(runtimes, muleVersion);
        }
        return null;
    }

    private String getTag(JsonArray runtimes, String muleVersion) {
        for (int i = 0; i < runtimes.size(); ++i) {
            JsonObject runtime = runtimes.get(i).getAsJsonObject();
            if (!runtime.has("versions")) continue;
            JsonArray versions = runtime.getAsJsonArray("versions");
            for (int j = 0; j < versions.size(); ++j) {
                JsonObject version = versions.get(j).getAsJsonObject();
                if (!version.has("baseVersion") || !version.has("tag") || !StringUtils.equals((CharSequence)version.get("baseVersion").getAsString(), (CharSequence)muleVersion)) continue;
                return version.get("tag").getAsString();
            }
        }
        return null;
    }

    protected String resolveTargetId() throws DeploymentException {
        String targetName = this.deployment.getTarget();
        JsonArray targets = this.client.getTargets();
        return RequestBuilder.getTargetId(targets, targetName);
    }

    public static String getTargetId(JsonArray targets, String targetName) throws DeploymentException {
        for (JsonElement targetElement : targets) {
            String currentTargetName;
            JsonElement nameElement;
            JsonObject target = targetElement.getAsJsonObject();
            if (target == null || (nameElement = target.get(NAME)) == null || !StringUtils.equals((CharSequence)targetName, (CharSequence)(currentTargetName = nameElement.getAsString()))) continue;
            return target.get(ID).getAsString();
        }
        throw new DeploymentException("Could not find target " + targetName);
    }

    protected ApplicationRequest buildApplicationRequest() {
        AssetReference assetReference = this.buildAssetReference();
        ApplicationRequest applicationRequest = new ApplicationRequest();
        applicationRequest.setRef(assetReference);
        applicationRequest.setDesiredState("STARTED");
        return applicationRequest;
    }

    protected AssetReference buildAssetReference() {
        AssetReference assetReference = new AssetReference();
        assetReference.setArtifactId(this.deployment.getArtifactId());
        assetReference.setGroupId(this.deployment.getGroupId());
        assetReference.setVersion(this.deployment.getVersion());
        assetReference.setPackaging("jar");
        return assetReference;
    }

    public String getDeploymentId(Target target) {
        Deployments deployments = this.client.getDeployments();
        for (DeploymentGenericResponse deployment : deployments) {
            if (!StringUtils.equals((CharSequence)deployment.name, (CharSequence)this.deployment.getApplicationName()) || !StringUtils.equals((CharSequence)deployment.target.targetId, (CharSequence)target.targetId)) continue;
            return deployment.id;
        }
        throw new IllegalStateException("Could not find deployment ID. Please check if there is an application with the same name under a different environment.");
    }

    public DeploymentModify buildDeploymentModify() throws DeploymentException {
        Target target = this.buildTarget();
        ApplicationModify applicationModify = this.buildApplicationModify();
        DeploymentModify deploymentModify = new DeploymentModify();
        deploymentModify.setTarget(target);
        deploymentModify.setApplication(applicationModify);
        return deploymentModify;
    }

    protected ApplicationModify buildApplicationModify() {
        AssetReference assetReference = this.buildAssetReference();
        ApplicationModify applicationModify = new ApplicationModify();
        applicationModify.setRef(assetReference);
        if (this.deployment.getProperties() != null) {
            HashMap applicationPropertiesService = new HashMap();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("properties", this.deployment.getProperties());
            properties.put("secureProperties", this.deployment.getSecureProperties());
            properties.put("applicationName", this.deployment.getApplicationName());
            applicationPropertiesService.put("mule.agent.application.properties.service", properties);
            applicationModify.setConfiguration(applicationPropertiesService);
        }
        return applicationModify;
    }
}

