/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation.cloudhub;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.client.cloudhub.model.SupportedVersion;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.validation.AbstractDeploymentValidator;
import org.mule.tools.validation.EnvironmentSupportedVersions;

public class CloudHubDeploymentValidator
extends AbstractDeploymentValidator {
    public CloudHubDeploymentValidator(Deployment deployment) {
        super(deployment);
    }

    @Override
    public EnvironmentSupportedVersions getEnvironmentSupportedVersions() throws DeploymentException {
        CloudHubClient client = this.getCloudHubClient();
        List<SupportedVersion> supportedMuleVersions = client.getSupportedMuleVersions();
        return new EnvironmentSupportedVersions(supportedMuleVersions.stream().map(sv -> sv.getVersion()).collect(Collectors.toSet()));
    }

    @VisibleForTesting
    protected CloudHubClient getCloudHubClient() {
        CloudHubClient client = new CloudHubClient((CloudHubDeployment)this.deployment, null);
        return client;
    }
}

