/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.agent.AbstractClient;
import org.mule.tools.client.arm.model.Environment;
import org.mule.tools.client.arm.model.Environments;
import org.mule.tools.client.arm.model.Organization;
import org.mule.tools.client.arm.model.UserInfo;
import org.mule.tools.client.authentication.AuthenticationServiceClient;
import org.mule.tools.client.authentication.model.Credentials;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractMuleClient
extends AbstractClient {
    private static final String ME = "/accounts/api/me";
    private static final String ENVIRONMENTS = "/accounts/api/organizations/%s/environments";
    private static final String ENV_ID_HEADER = "X-ANYPNT-ENV-ID";
    private static final String ORG_ID_HEADER = "X-ANYPNT-ORG-ID";
    public static final String DEFAULT_BASE_URL = "https://anypoint.mulesoft.com";
    protected String baseUri;
    private String bearerToken;
    private Credentials credentials;
    protected AuthenticationServiceClient authenticationServiceClient;
    private String envId;
    private String environmentName;
    private String orgId;
    private String businessGroupName;

    public AbstractMuleClient(AnypointDeployment anypointDeployment, DeployerLog log) {
        super(log);
        this.baseUri = anypointDeployment.getUri();
        this.credentials = new Credentials(anypointDeployment.getUsername(), anypointDeployment.getPassword());
        this.authenticationServiceClient = new AuthenticationServiceClient(this.baseUri);
        this.environmentName = anypointDeployment.getEnvironment();
        this.businessGroupName = anypointDeployment.getBusinessGroup();
    }

    public void init() {
        this.bearerToken = this.getBearerToken(this.credentials);
        this.orgId = this.getOrgId();
        this.envId = this.findEnvironmentByName((String)this.environmentName).id;
    }

    public UserInfo getMe() {
        UserInfo userInfo = this.get(this.baseUri, ME, UserInfo.class);
        return userInfo;
    }

    public String getOrgId() {
        return this.getBusinessGroupIdByBusinessGroupPath();
    }

    public Environment findEnvironmentByName(String name) {
        Environments response = this.getEnvironments();
        if (response == null || response.data == null) {
            StringBuilder message = new StringBuilder();
            message.append("Please check whether you have the access rights to this business group.");
            if (StringUtils.isEmpty((CharSequence)this.businessGroupName)) {
                message.append(" Please set the businessGroup in the plugin configuration in case your user have access only within a business unit.");
            }
            throw new RuntimeException(message.toString());
        }
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find environmentName named [" + name + "]");
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header("Authorization", (Object)("bearer " + this.bearerToken));
        }
        if (this.envId != null && this.orgId != null) {
            builder.header(ENV_ID_HEADER, (Object)this.envId);
            builder.header(ORG_ID_HEADER, (Object)this.orgId);
        }
    }

    protected String[] createBusinessGroupPath() {
        int i;
        if (StringUtils.isEmpty((CharSequence)this.businessGroupName)) {
            return new String[0];
        }
        ArrayList<String> groups = new ArrayList<String>();
        String group = "";
        for (i = 0; i < this.businessGroupName.length() - 1; ++i) {
            if (this.businessGroupName.charAt(i) == '\\') {
                if (this.businessGroupName.charAt(i + 1) == '\\') {
                    group = group + "\\";
                    ++i;
                    continue;
                }
                groups.add(group);
                group = "";
                continue;
            }
            group = group + this.businessGroupName.charAt(i);
        }
        if (i < this.businessGroupName.length()) {
            group = group + this.businessGroupName.charAt(this.businessGroupName.length() - 1);
        }
        groups.add(group);
        return groups.toArray(new String[0]);
    }

    private String getBusinessGroupIdByBusinessGroupPath() {
        String currentOrgId = null;
        Organization organizationHierarchy = this.getOrganizationHierarchy();
        if (organizationHierarchy.subOrganizations.isEmpty()) {
            return organizationHierarchy.id;
        }
        List<Organization> subOrganizations = organizationHierarchy.subOrganizations;
        String[] groups = this.createBusinessGroupPath();
        if (groups.length == 0) {
            currentOrgId = organizationHierarchy.id;
        } else {
            block0: for (int group = 0; group < groups.length; ++group) {
                String groupName = groups[group];
                for (Organization o : subOrganizations) {
                    if (!o.name.equals(groupName)) continue;
                    currentOrgId = o.id;
                    subOrganizations = o.subOrganizations;
                    continue block0;
                }
            }
        }
        if (currentOrgId == null) {
            throw new ArrayIndexOutOfBoundsException("Cannot find business group.");
        }
        return currentOrgId;
    }

    private Organization getOrganizationHierarchy() {
        String rootOrgId = this.getMe().user.organization.id;
        String organizationHiearchy = this.get(this.baseUri, "accounts/api/organizations/" + rootOrgId + "/hierarchy", String.class);
        Organization organization = (Organization)new Gson().fromJson(organizationHiearchy, Organization.class);
        return organization;
    }

    private String getBearerToken(Credentials credentials) {
        if (StringUtils.isBlank((CharSequence)this.bearerToken)) {
            this.bearerToken = this.authenticationServiceClient.getBearerToken(credentials);
        }
        return this.bearerToken;
    }

    public Environments getEnvironments() {
        return this.get(this.baseUri, String.format(ENVIRONMENTS, this.orgId), Environments.class);
    }
}

