/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.verification.arm;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.mule.tools.client.arm.ArmClient;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.verification.DefaultDeploymentVerification;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.DeploymentVerificationStrategy;

public class ArmDeploymentVerification
implements DeploymentVerification {
    private final ArmClient client;
    private final Integer applicationId;
    private DeploymentVerification verification;

    public ArmDeploymentVerification(ArmClient client, Integer applicationId) {
        this.client = client;
        this.applicationId = applicationId;
        this.verification = new DefaultDeploymentVerification(new ArmDeploymentVerificationStrategy());
    }

    @Override
    public void assertDeployment(Deployment deployment) throws DeploymentException {
        this.verification.assertDeployment(deployment);
    }

    private class ArmDeploymentVerificationStrategy
    implements DeploymentVerificationStrategy {
        private ArmDeploymentVerificationStrategy() {
        }

        @Override
        public Predicate<Deployment> isDeployed() {
            return deployment -> ArmDeploymentVerification.this.client.isStarted(ArmDeploymentVerification.this.applicationId);
        }

        @Override
        public Consumer<Deployment> onTimeout() {
            return deployment -> ArmDeploymentVerification.this.client.undeployApplication(ArmDeploymentVerification.this.applicationId);
        }
    }
}

