/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.agent;

import org.mule.tools.client.agent.AgentClient;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.deployment.artifact.ArtifactDeployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.verification.agent.AgentDeploymentVerification;

public class AgentArtifactDeployer
implements ArtifactDeployer {
    private static final Long DEFAULT_AGENT_TIMEOUT = 60000L;
    private final AgentDeployment deployment;
    private final AgentClient client;

    public AgentArtifactDeployer(Deployment deployment, DeployerLog log) {
        this(deployment, new AgentClient(log, deployment));
    }

    protected AgentArtifactDeployer(Deployment deployment, AgentClient client) {
        this.deployment = (AgentDeployment)deployment;
        if (!this.deployment.getDeploymentTimeout().isPresent()) {
            this.deployment.setDeploymentTimeout(DEFAULT_AGENT_TIMEOUT);
        }
        this.client = client;
    }

    @Override
    public void deployDomain() throws DeploymentException {
        this.client.deployDomain(this.deployment.getApplicationName(), this.deployment.getArtifact());
    }

    @Override
    public void undeployDomain() throws DeploymentException {
        this.client.undeployDomain(this.deployment.getApplicationName());
    }

    @Override
    public void deployApplication() throws DeploymentException {
        this.client.deployApplication(this.deployment.getApplicationName(), this.deployment.getArtifact());
        AgentDeploymentVerification verification = this.getDeploymentVerification();
        verification.assertDeployment(this.deployment);
    }

    @Override
    public void undeployApplication() throws DeploymentException {
        this.client.undeployApplication(this.deployment.getApplicationName());
    }

    public AgentDeploymentVerification getDeploymentVerification() {
        return new AgentDeploymentVerification(this.client);
    }
}

