/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.cloudhub;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.tools.client.AbstractMuleClient;
import org.mule.tools.client.cloudhub.Application;
import org.mule.tools.client.cloudhub.ApplicationMetadata;
import org.mule.tools.client.exception.ClientException;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.utils.DeployerLog;

public class CloudHubClient
extends AbstractMuleClient {
    public static final String STARTED_STATUS = "STARTED";
    public static final String UNDEPLOYED_STATUS = "UNDEPLOYED";
    private static final String APPLICATIONS_PATH = "/cloudhub/api/applications";
    private static final String DOMAINS_PATH = "/cloudhub/api/applications/domains/";
    private static final String APPLICATION_UPDATE_PATH = "/cloudhub/api/v2/applications/%s";
    private static final String APPLICATIONS_FILES_PATH = "/cloudhub/api/v2/applications/%s/files";
    private static final String SUPPORTED_VERSIONS_PATH = "cloudhub/api/mule-versions";
    private static final String CREATE_REQUEST_TEMPLATE = "{  \"domain\": \"%s\",  \"region\": \"%s\",  \"muleVersion\": \"%s\",  \"workers\": %d,  \"workerType\": \"%s\"";
    private static final String UPDATE_REQUEST_TEMPLATE = "{  \"region\":\"%s\",  \"muleVersion\": {\"version\": \"%s\"},  \"workers\": {    \"amount\": %d,    \"type\": {        \"name\": \"%s\"    }  }";
    private static final int OK = 200;
    private static final int CREATED = 201;
    private static final int NO_CONTENT = 204;
    private static final int MOVED_PERMANENTLY = 301;
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_FOUND = 404;

    public CloudHubClient(CloudHubDeployment cloudhubDeployment, DeployerLog log) {
        super(cloudhubDeployment, log);
    }

    public Application createApplication(ApplicationMetadata metadata) {
        Entity<String> json = this.createApplicationRequest(metadata);
        Response response = this.post(this.baseUri, APPLICATIONS_PATH, json);
        if (response.getStatus() == 201) {
            return (Application)response.readEntity(Application.class);
        }
        throw new ClientException(response);
    }

    private Entity<String> createApplicationRequest(ApplicationMetadata metadata) {
        String json = String.format(CREATE_REQUEST_TEMPLATE, metadata.getName(), metadata.getRegion(), metadata.getMuleVersion().get(), metadata.getWorkers(), metadata.getWorkerType());
        json = this.addProperties(metadata.getProperties(), json);
        json = json + "}";
        return Entity.json((Object)json);
    }

    private Entity<String> updateApplicationRequest(ApplicationMetadata metadata) {
        String json = String.format(UPDATE_REQUEST_TEMPLATE, metadata.getRegion(), metadata.getMuleVersion().get(), metadata.getWorkers(), metadata.getWorkerType());
        json = this.addProperties(metadata.getProperties(), json);
        json = json + "}";
        return Entity.json((Object)json);
    }

    private String addProperties(Map<String, String> properties, String json) {
        if (properties == null) {
            return json;
        }
        json = json + ",";
        json = json + "  \"properties\": {";
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            json = json + "    \"" + entry.getKey() + "\":\"" + entry.getValue() + "\",";
        }
        if (json.charAt(json.length() - 1) == ',') {
            json = json.substring(0, json.length() - 1);
        }
        json = json + "  }\n";
        return json;
    }

    public void updateApplication(ApplicationMetadata metadata) {
        Entity<String> json = this.updateApplicationRequest(metadata);
        Response response = this.put(this.baseUri, String.format(APPLICATION_UPDATE_PATH, metadata.getName()), json);
        if (response.getStatus() != 200 && response.getStatus() != 301) {
            throw new ClientException(response);
        }
    }

    public Application getApplication(String appName) {
        Response response = this.get(this.baseUri, "/cloudhub/api/applications/" + appName);
        if (response.getStatus() == 200) {
            return (Application)response.readEntity(Application.class);
        }
        if (response.getStatus() == 404) {
            return null;
        }
        throw new ClientException(response);
    }

    public List<Application> getApplications() {
        Response response = this.get(this.baseUri, APPLICATIONS_PATH);
        if (response.getStatus() == 200) {
            return (List)response.readEntity((GenericType)new GenericType<List<Application>>(){});
        }
        throw new ClientException(response);
    }

    public void uploadFile(String appName, File file) {
        FileDataBodyPart applicationPart = new FileDataBodyPart("file", file);
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)applicationPart);
        Response response = this.post(this.baseUri, String.format(APPLICATIONS_FILES_PATH, appName), Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() != 200) {
            throw new ClientException(response);
        }
    }

    public void startApplication(String appName) {
        this.changeApplicationState(appName, "START");
    }

    public void stopApplication(String appName) {
        this.changeApplicationState(appName, "STOP");
    }

    private void changeApplicationState(String appName, String state) {
        Entity json = Entity.json((Object)("{\"status\": \"" + state + "\"}"));
        Response response = this.post(this.baseUri, "/cloudhub/api/applications/" + appName + "/status", json);
        if (response.getStatus() != 200 && response.getStatus() != 304) {
            throw new ClientException(response);
        }
    }

    public void deleteApplication(String appName) {
        Response response = this.delete(this.baseUri, "/cloudhub/api/applications/" + appName);
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            throw new ClientException(response);
        }
    }

    public boolean isNameAvailable(String appName) {
        Response response = this.get(this.baseUri, DOMAINS_PATH + appName);
        if (response.getStatus() == 200) {
            DomainAvailability availability = (DomainAvailability)response.readEntity(DomainAvailability.class);
            return availability.available;
        }
        throw new ClientException(response);
    }

    public Set<String> getSupportedMuleVersions() {
        HashSet<String> supportedMuleVersions = new HashSet<String>();
        String jsonResponse = (String)this.get(this.baseUri, SUPPORTED_VERSIONS_PATH).readEntity(String.class);
        JsonObject response = new JsonParser().parse(jsonResponse).getAsJsonObject();
        JsonArray dataElements = response.get("data").getAsJsonArray();
        for (JsonElement dataElement : dataElements) {
            JsonObject data = dataElement.getAsJsonObject();
            String muleVersion = data.get("version").getAsString();
            supportedMuleVersions.add(muleVersion);
        }
        return supportedMuleVersions;
    }

    private static class DomainAvailability {
        public boolean available;

        private DomainAvailability() {
        }
    }
}

