/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.utils;

import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.agent.AgentDeployer;
import org.mule.tools.client.arm.ArmDeployer;
import org.mule.tools.client.cloudhub.CloudhubDeployer;
import org.mule.tools.client.standalone.deployment.StandaloneDeployer;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.model.standalone.ClusterDeployment;
import org.mule.tools.model.standalone.StandaloneDeployment;
import org.mule.tools.utils.DeployerLog;

public class DeployerFactory {
    public AbstractDeployer createDeployer(Deployment deploymentConfiguration, DeployerLog log) throws DeploymentException {
        if (deploymentConfiguration instanceof StandaloneDeployment) {
            return new StandaloneDeployer((StandaloneDeployment)deploymentConfiguration, log);
        }
        if (deploymentConfiguration instanceof ClusterDeployment) {
            throw new DeploymentException("Unsupported deploymentConfiguration type: " + deploymentConfiguration);
        }
        if (deploymentConfiguration instanceof ArmDeployment) {
            return new ArmDeployer((ArmDeployment)deploymentConfiguration, log);
        }
        if (deploymentConfiguration instanceof CloudHubDeployment) {
            return new CloudhubDeployer((CloudHubDeployment)deploymentConfiguration, log);
        }
        if (deploymentConfiguration instanceof AgentDeployment) {
            return new AgentDeployer((AgentDeployment)deploymentConfiguration, log);
        }
        throw new DeploymentException("Unsupported deploymentConfiguration type: " + deploymentConfiguration);
    }
}

