/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.cloudhub;

import com.google.common.base.Preconditions;
import groovy.util.ScriptException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.cloudhub.Application;
import org.mule.tools.client.cloudhub.CloudhubClient;
import org.mule.tools.client.exception.ClientException;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.utils.DeployerLog;

public class CloudhubDeployer
extends AbstractDeployer {
    private final CloudHubDeployment cloudhubDeployment;
    private CloudhubClient cloudhubClient;

    public CloudhubDeployer(CloudHubDeployment cloudHubDeployment, DeployerLog log) throws DeploymentException {
        super(cloudHubDeployment, log);
        this.cloudhubDeployment = cloudHubDeployment;
    }

    @Override
    public void deploy() throws DeploymentException {
        this.cloudhubClient.init();
        this.info("Deploying application " + this.getApplicationName() + " to Cloudhub");
        if (!this.getApplicationFile().exists()) {
            throw new DeploymentException("Application file " + this.getApplicationFile() + " does not exist.");
        }
        try {
            boolean domainAvailable = this.cloudhubClient.isNameAvailable(this.getApplicationName());
            if (domainAvailable) {
                this.info("Creating application " + this.getApplicationName());
                this.cloudhubClient.createApplication(this.getApplicationName(), this.cloudhubDeployment.getRegion(), this.cloudhubDeployment.getMuleVersion().get(), this.cloudhubDeployment.getWorkers().get(), this.cloudhubDeployment.getWorkerType(), this.cloudhubDeployment.getProperties());
            } else {
                Application app = this.findApplicationFromCurrentUser(this.getApplicationName());
                if (app != null) {
                    this.info("Application " + this.getApplicationName() + " already exists, redeploying");
                    String updateRegion = this.cloudhubDeployment.getRegion() == null ? app.region : this.cloudhubDeployment.getRegion();
                    String updateMuleVersion = this.cloudhubDeployment.getMuleVersion() == null ? app.muleVersion : this.cloudhubDeployment.getMuleVersion().get();
                    Integer updateWorkers = this.cloudhubDeployment.getWorkers() == null ? app.workers : this.cloudhubDeployment.getWorkers().get();
                    String updateWorkerType = this.cloudhubDeployment.getWorkerType() == null ? app.workerType : this.cloudhubDeployment.getWorkerType();
                    this.cloudhubClient.updateApplication(this.getApplicationName(), updateRegion, updateMuleVersion, updateWorkers, updateWorkerType, this.cloudhubDeployment.getProperties());
                } else {
                    this.error("Domain " + this.getApplicationName() + " is not available. Aborting.");
                    throw new DeploymentException("Domain " + this.getApplicationName() + " is not available. Aborting.");
                }
            }
            this.info("Uploading application contents " + this.getApplicationName());
            this.cloudhubClient.uploadFile(this.getApplicationName(), this.getApplicationFile());
            this.info("Starting application " + this.getApplicationName());
            this.cloudhubClient.startApplication(this.getApplicationName());
        }
        catch (ClientException e) {
            this.error("Failed: " + e.getMessage());
            throw new DeploymentException("Failed to deploy application " + this.getApplicationName(), e);
        }
    }

    @Override
    public void undeploy(MavenProject mavenProject) throws DeploymentException {
        CloudhubClient cloudhubClient = new CloudhubClient(this.cloudhubDeployment, this.log);
        cloudhubClient.init();
        this.log.info("Stopping application " + this.cloudhubDeployment.getApplicationName());
        cloudhubClient.stopApplication(this.cloudhubDeployment.getApplicationName());
    }

    @Override
    protected void initialize() {
        this.cloudhubClient = new CloudhubClient((CloudHubDeployment)this.deploymentConfiguration, this.log);
    }

    @Override
    public void resolveDependencies(MavenProject mavenProject, ArtifactResolver artifactResolver, ArchiverManager archiverManager, ArtifactFactory artifactFactory, ArtifactRepository localRepository) throws DeploymentException, ScriptException {
    }

    protected Application findApplicationFromCurrentUser(String appName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appName), (Object)"Application name should not be blank nor null");
        for (Application app : this.getApplications()) {
            if (!appName.equalsIgnoreCase(app.domain)) continue;
            return app;
        }
        return null;
    }

    public List<Application> getApplications() {
        return this.cloudhubClient.getApplications();
    }
}

