/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.model.anypoint;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.model.TargetType;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.utils.VersionUtils;

public class ArmDeployment
extends AnypointDeployment {
    private static final String FIRST_ARM_VERSION_THAT_ACCEPTS_PROPERTIES = "3.9.0";
    @Parameter
    protected String target;
    @Parameter
    protected TargetType targetType;
    @Parameter
    protected Boolean armInsecure;
    @Parameter
    protected Boolean failIfNotExists;

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public Boolean isArmInsecure() {
        return this.armInsecure;
    }

    public void setArmInsecure(boolean armInsecure) {
        this.armInsecure = armInsecure;
    }

    public Boolean isFailIfNotExists() {
        return this.failIfNotExists;
    }

    public void setFailIfNotExists(boolean failIfNotExists) {
        this.failIfNotExists = failIfNotExists;
    }

    @Override
    public void setEnvironmentSpecificValues() throws DeploymentException {
        String targetType;
        String anypointTarget;
        super.setEnvironmentSpecificValues();
        String isArmInsecure = System.getProperty("arm.insecure");
        if (StringUtils.isNotBlank((CharSequence)isArmInsecure)) {
            this.setArmInsecure(Boolean.valueOf(isArmInsecure));
        }
        if (this.isArmInsecure() == null) {
            this.setArmInsecure(false);
        }
        if (this.isFailIfNotExists() == null) {
            this.setFailIfNotExists(Boolean.TRUE);
        }
        if (StringUtils.isNotBlank((CharSequence)(anypointTarget = System.getProperty("anypoint.target")))) {
            this.setTarget(anypointTarget);
        }
        if (StringUtils.isNotBlank((CharSequence)(targetType = System.getProperty("anypoint.target.type")))) {
            this.setTargetType(TargetType.valueOf(targetType));
        }
        if (!VersionUtils.isGreaterThanOrSameVersion(this.muleVersion, FIRST_ARM_VERSION_THAT_ACCEPTS_PROPERTIES) && this.properties != null) {
            throw new DeploymentException("Properties are not allowed. Mule Runtime version should be at least 3.9.0");
        }
    }
}

