/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class Artifact
implements Comparable {
    public static final String MULE_DOMAIN = "mule-domain";
    private ArtifactCoordinates artifactCoordinates;
    private URI uri;
    private boolean isShared = false;
    private String[] packages;
    private String[] resources;

    public Artifact(ArtifactCoordinates artifactCoordinates, URI uri) {
        this.setArtifactCoordinates(artifactCoordinates);
        this.setUri(uri);
    }

    public ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        if (!StringUtils.equals((CharSequence)MULE_DOMAIN, (CharSequence)this.artifactCoordinates.getClassifier())) {
            Preconditions.checkNotNull((Object)uri, (Object)"Uri cannot be null");
        }
        this.uri = uri;
    }

    private void setArtifactCoordinates(ArtifactCoordinates artifactCoordinates) {
        Preconditions.checkNotNull((Object)artifactCoordinates, (Object)"Artifact coordinates cannot be null");
        this.artifactCoordinates = artifactCoordinates;
    }

    public String toString() {
        return this.artifactCoordinates.toString();
    }

    public int compareTo(Object that) {
        return this.getArtifactCoordinates().toString().compareTo(that.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Artifact)) {
            return false;
        }
        Artifact that = (Artifact)o;
        return this.getArtifactCoordinates().equals(that.getArtifactCoordinates());
    }

    public int hashCode() {
        return this.getArtifactCoordinates().hashCode();
    }

    public Artifact copyWithParameterizedUri() {
        if (StringUtils.equals((CharSequence)this.artifactCoordinates.getClassifier(), (CharSequence)MULE_DOMAIN)) {
            return new Artifact(this.artifactCoordinates, this.uri);
        }
        Artifact newArtifact = new Artifact(this.artifactCoordinates, this.uri);
        File repositoryFolder = new File("repository");
        String artifactFilename = Artifact.getFormattedArtifactFileName(newArtifact);
        String newUriPath = Artifact.getFormattedMavenDirectory(repositoryFolder, this.getArtifactCoordinates()).getPath();
        File newArtifactFile = new File(newUriPath, artifactFilename);
        newArtifact.setShared(this.isShared);
        newArtifact.setPackages(this.packages);
        newArtifact.setResources(this.resources);
        try {
            this.setNewArtifactURI(newArtifact, newArtifactFile);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not generate URI for resource, the given path is invalid: " + newUriPath, e);
        }
        return newArtifact;
    }

    public static File getFormattedMavenDirectory(File outputDirectory, ArtifactCoordinates artifactCoordinates) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifactCoordinates.getGroupId().replace('.', File.separatorChar)).append(File.separatorChar);
        sb.append(artifactCoordinates.getArtifactId()).append(File.separatorChar);
        sb.append(artifactCoordinates.getVersion()).append(File.separatorChar);
        return new File(outputDirectory, sb.toString());
    }

    public static String getFormattedArtifactFileName(Artifact artifact) {
        ArtifactCoordinates artifactCoordinates = artifact.getArtifactCoordinates();
        String destFileName = Artifact.buildMainFileName(artifactCoordinates);
        String extension = artifactCoordinates.getType();
        return destFileName + "." + extension;
    }

    private static String buildMainFileName(ArtifactCoordinates artifactCoordinates) {
        String versionString = "-" + artifactCoordinates.getVersion();
        String classifierString = "";
        if (StringUtils.isNotBlank((CharSequence)artifactCoordinates.getClassifier())) {
            classifierString = "-" + artifactCoordinates.getClassifier();
        }
        return artifactCoordinates.getArtifactId() + versionString + classifierString;
    }

    public void setNewArtifactURI(Artifact newArtifact, File newArtifactFile) throws URISyntaxException {
        String relativePath = FilenameUtils.normalize((String)newArtifactFile.getPath(), (boolean)true);
        newArtifact.setUri(new URI(relativePath));
    }

    public static String getPomFileName(Artifact artifact) {
        return Artifact.buildMainPOMFileName(artifact.getArtifactCoordinates()) + ".pom";
    }

    public static String buildMainPOMFileName(ArtifactCoordinates artifactCoordinates) {
        String versionString = "-" + artifactCoordinates.getVersion();
        return artifactCoordinates.getArtifactId() + versionString;
    }

    public String getPomFileName() {
        return Artifact.getPomFileName(this);
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean isShared) {
        this.isShared = isShared;
    }

    public String getFormattedArtifactFileName() {
        return Artifact.getFormattedArtifactFileName(this);
    }

    public File getFormattedMavenDirectory(File repositoryFile) {
        return Artifact.getFormattedMavenDirectory(repositoryFile, this.artifactCoordinates);
    }

    public String[] getPackages() {
        return this.packages;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }
}

