/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipArchiver {
    private final Set<String> blackList;

    public ZipArchiver() {
        this.blackList = Collections.EMPTY_SET;
    }

    public ZipArchiver(String[] blackList) {
        this.blackList = new HashSet<String>(Arrays.asList(blackList));
    }

    public void toZip(File fileToZip, String outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        this.toZip(fileToZip, fileToZip.getName(), zipOut);
        zipOut.close();
        fos.close();
    }

    protected void toZip(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        if (!this.isInBlackList(fileToZip)) {
            if (fileToZip.isDirectory()) {
                File[] children = fileToZip.listFiles();
                ZipEntry zipEntry = new ZipEntry(fileName + "/");
                zipOut.putNextEntry(zipEntry);
                if (children != null) {
                    for (File childFile : children) {
                        this.toZip(childFile, fileName + "/" + childFile.getName(), zipOut);
                    }
                }
            } else {
                int length;
                FileInputStream fis = new FileInputStream(fileToZip);
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zipOut.write(bytes, 0, length);
                }
                fis.close();
            }
        }
    }

    private boolean isInBlackList(File fileToZip) {
        return this.blackList.contains(fileToZip.getName());
    }
}

