/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.datatype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.query.expression.EqualsOperator;
import org.mule.common.query.expression.GreaterOperator;
import org.mule.common.query.expression.GreaterOrEqualsOperator;
import org.mule.common.query.expression.LessOperator;
import org.mule.common.query.expression.LessOrEqualsOperator;
import org.mule.common.query.expression.LikeOperator;
import org.mule.common.query.expression.NotEqualsOperator;
import org.mule.common.query.expression.Operator;

public class SupportedOperatorsFactory {
    private static SupportedOperatorsFactory instance = new SupportedOperatorsFactory();

    private SupportedOperatorsFactory() {
    }

    public static SupportedOperatorsFactory getInstance() {
        return instance;
    }

    public List<Operator> getSupportedOperationsFor(DataType dataType) {
        switch (dataType) {
            case BOOLEAN: 
            case ENUM: {
                return Arrays.asList(new EqualsOperator(), new NotEqualsOperator());
            }
            case DATE_TIME: 
            case DATE: 
            case BYTE: 
            case NUMBER: 
            case INTEGER: 
            case LONG: 
            case DOUBLE: 
            case DECIMAL: {
                return this.getCommonOperations();
            }
            case STRING: {
                List<Operator> operators = this.getCommonOperations();
                operators.add((Operator)new LikeOperator());
                return operators;
            }
        }
        return new ArrayList<Operator>();
    }

    public List<Operator> getCommonOperations() {
        ArrayList<Operator> operators = new ArrayList<Operator>();
        operators.add((Operator)new LessOperator());
        operators.add((Operator)new LessOrEqualsOperator());
        operators.add((Operator)new EqualsOperator());
        operators.add((Operator)new GreaterOperator());
        operators.add((Operator)new GreaterOrEqualsOperator());
        operators.add((Operator)new NotEqualsOperator());
        return operators;
    }
}

