/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.builder;

import java.util.ArrayList;
import java.util.List;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.builder.MetaDataBuilder;
import org.mule.common.metadata.builder.MetaDataFieldBuilder;
import org.mule.common.metadata.field.property.DefaultFieldPropertyFactory;
import org.mule.common.metadata.field.property.ExampleFieldProperty;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;
import org.mule.common.metadata.field.property.ValidStringValuesFieldProperty;
import org.mule.common.metadata.field.property.dsql.DsqlOrderMetaDataFieldProperty;
import org.mule.common.metadata.field.property.dsql.DsqlQueryOperatorsMetaDataFieldProperty;
import org.mule.common.metadata.field.property.dsql.DsqlSelectMetaDataFieldProperty;
import org.mule.common.metadata.field.property.dsql.DsqlWhereMetaDataFieldProperty;
import org.mule.common.metadata.property.DescriptionMetaDataProperty;
import org.mule.common.metadata.property.LabelMetaDataProperty;
import org.mule.common.query.expression.EqualsOperator;
import org.mule.common.query.expression.GreaterOperator;
import org.mule.common.query.expression.GreaterOrEqualsOperator;
import org.mule.common.query.expression.LessOperator;
import org.mule.common.query.expression.LessOrEqualsOperator;
import org.mule.common.query.expression.LikeOperator;
import org.mule.common.query.expression.NotEqualsOperator;
import org.mule.common.query.expression.Operator;

public class DefaultMetaDataFieldBuilder
implements MetaDataFieldBuilder {
    private String name;
    private List<Class<? extends MetaDataFieldProperty>> undesiredFieldProperties;
    private MetaDataField.FieldAccessType accessType;
    private MetaDataBuilder<?> builder;
    private List<Operator> supportedOperators;
    private String[] enumValues = null;
    private String exampleString = null;
    private String label;
    private String description;

    DefaultMetaDataFieldBuilder(String name, MetaDataBuilder<?> builder) {
        this.name = name;
        this.builder = builder;
        this.supportedOperators = new ArrayList<Operator>();
        this.undesiredFieldProperties = new ArrayList<Class<? extends MetaDataFieldProperty>>();
    }

    public MetaDataFieldBuilder isSelectCapable(boolean capable) {
        if (!capable) {
            this.undesiredFieldProperties.add(DsqlSelectMetaDataFieldProperty.class);
        }
        return this;
    }

    public MetaDataFieldBuilder isOrderByCapable(boolean capable) {
        if (!capable) {
            this.undesiredFieldProperties.add(DsqlOrderMetaDataFieldProperty.class);
        }
        return this;
    }

    public void isWhereCapable(boolean capable) {
        if (!capable) {
            this.undesiredFieldProperties.add(DsqlWhereMetaDataFieldProperty.class);
        }
    }

    public void setEnumValues(String ... values) {
        this.enumValues = values;
    }

    public void setExample(String example) {
        this.exampleString = example;
    }

    public void supportsEquals() {
        this.supportedOperators.add((Operator)new EqualsOperator());
    }

    public void supportsNotEquals() {
        this.supportedOperators.add((Operator)new NotEqualsOperator());
    }

    public void supportsGreater() {
        this.supportedOperators.add((Operator)new GreaterOperator());
    }

    public void supportsGreaterOrEquals() {
        this.supportedOperators.add((Operator)new GreaterOrEqualsOperator());
    }

    public void supportsLess() {
        this.supportedOperators.add((Operator)new LessOperator());
    }

    public void supportsLessOrEquals() {
        this.supportedOperators.add((Operator)new LessOrEqualsOperator());
    }

    public void supportsLike() {
        this.supportedOperators.add((Operator)new LikeOperator());
    }

    public void withAccessType(MetaDataField.FieldAccessType accessType) {
        this.accessType = accessType;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MetaDataField build() {
        DefaultFieldPropertyFactory defaultFieldPropertyFactory = new DefaultFieldPropertyFactory();
        Object model = this.builder.build();
        ArrayList<MetaDataFieldProperty> fieldProperties = new ArrayList<MetaDataFieldProperty>();
        fieldProperties.addAll(defaultFieldPropertyFactory.getProperties("null", (MetaDataModel)model));
        if (!this.supportedOperators.isEmpty()) {
            for (MetaDataFieldProperty metaDataFieldProperty : fieldProperties) {
                if (!(metaDataFieldProperty instanceof DsqlQueryOperatorsMetaDataFieldProperty)) continue;
                DsqlQueryOperatorsMetaDataFieldProperty operatorsMetaDataFieldProperty = (DsqlQueryOperatorsMetaDataFieldProperty)metaDataFieldProperty;
                operatorsMetaDataFieldProperty.setSupportedOperators(this.supportedOperators);
            }
        }
        ArrayList<MetaDataFieldProperty> finalFieldProperties = new ArrayList<MetaDataFieldProperty>();
        for (MetaDataFieldProperty property : fieldProperties) {
            if (this.undesiredFieldProperties.contains(property.getClass())) continue;
            finalFieldProperties.add(property);
        }
        if (this.description != null) {
            finalFieldProperties.add(new DescriptionMetaDataProperty(this.description));
        }
        if (this.label != null) {
            finalFieldProperties.add(new LabelMetaDataProperty(this.label));
        }
        if (this.enumValues != null) {
            finalFieldProperties.add(new ValidStringValuesFieldProperty(this.enumValues));
        }
        if (this.exampleString != null) {
            finalFieldProperties.add(new ExampleFieldProperty(this.exampleString));
        }
        if (this.accessType == null) {
            this.accessType = MetaDataField.FieldAccessType.READ_WRITE;
        }
        return new DefaultMetaDataField(this.name, (MetaDataModel)model, this.accessType, (List<MetaDataFieldProperty>)finalFieldProperties);
    }
}

