/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.PrimitiveType;
import org.mule.devkit.model.code.TypeReference;

public abstract class Type
implements Generable,
Comparable<Type> {
    public static PrimitiveType parse(CodeModel codeModel, String typeName) {
        if (typeName.equals("void")) {
            return codeModel.VOID;
        }
        if (typeName.equals("boolean")) {
            return codeModel.BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return codeModel.BYTE;
        }
        if (typeName.equals("short")) {
            return codeModel.SHORT;
        }
        if (typeName.equals("char")) {
            return codeModel.CHAR;
        }
        if (typeName.equals("int")) {
            return codeModel.INT;
        }
        if (typeName.equals("float")) {
            return codeModel.FLOAT;
        }
        if (typeName.equals("long")) {
            return codeModel.LONG;
        }
        if (typeName.equals("double")) {
            return codeModel.DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive type: " + typeName);
    }

    public abstract CodeModel owner();

    public abstract String fullName();

    public String binaryName() {
        return this.fullName();
    }

    public abstract String name();

    public abstract TypeReference array();

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public abstract TypeReference boxify();

    public abstract Type unboxify();

    public Type erasure() {
        return this;
    }

    public final boolean isReference() {
        return !this.isPrimitive();
    }

    public Type elementType() {
        throw new IllegalArgumentException("Not an array type");
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fullName() + ')';
    }

    @Override
    public int compareTo(Type o) {
        String rhs = o.fullName();
        boolean p = this.fullName().startsWith("java");
        boolean q = rhs.startsWith("java");
        if (p && !q) {
            return -1;
        }
        if (!p && q) {
            return 1;
        }
        return this.fullName().compareTo(rhs);
    }

    public int hashCode() {
        return this.fullName().hashCode();
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        Type other = (Type)this.getClass().cast(oth);
        return this.fullName().equals(other.fullName());
    }

    public final GeneratedExpression dotclass() {
        return ExpressionFactory.dotclass(this);
    }
}

