/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model.module.rest;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.annotations.rest.BinaryParam;
import org.mule.api.annotations.rest.HttpMethod;
import org.mule.api.annotations.rest.RestHeaderParam;
import org.mule.api.annotations.rest.RestPostParam;
import org.mule.api.annotations.rest.RestQueryParam;
import org.mule.api.annotations.rest.RestUriParam;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.apt.model.module.AnnotationProcessorProcessorMethod;
import org.mule.devkit.apt.model.module.rest.AnnotationProcessorRestParameter;
import org.mule.devkit.apt.model.module.rest.RestAnnotationProcessorExceptionOn;
import org.mule.devkit.apt.model.module.rest.RestAnnotationProcessorTimeout;
import org.mule.devkit.apt.model.utils.AnnotationUtils;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.Component;
import org.mule.devkit.model.module.rest.RestCall;
import org.mule.devkit.model.module.rest.RestExceptionOn;
import org.mule.devkit.model.module.rest.RestParameter;
import org.mule.devkit.model.module.rest.RestTimeout;

public class AnnotationProcessorRestCall
extends AnnotationProcessorProcessorMethod
implements RestCall {
    public AnnotationProcessorRestCall(ExecutableElement element, Type parent, Types types, Elements elements, List<Component> components, Module module) {
        super(element, parent, types, elements, components, module);
    }

    public HttpMethod getRestNoun() {
        return ((ExecutableElement)this.innerElement).getAnnotation(org.mule.api.annotations.rest.RestCall.class).method();
    }

    public String getContentType() {
        return ((ExecutableElement)this.innerElement).getAnnotation(org.mule.api.annotations.rest.RestCall.class).contentType();
    }

    public String getUri() {
        return ((ExecutableElement)this.innerElement).getAnnotation(org.mule.api.annotations.rest.RestCall.class).uri();
    }

    public List<RestParameter> getUriParameters() {
        return this.getRestParametersAnnotatedWith(RestUriParam.class);
    }

    public List<RestParameter> getQueryParameters() {
        return this.getRestParametersAnnotatedWith(RestQueryParam.class);
    }

    public List<RestParameter> getHeaderParameters() {
        return this.getRestParametersAnnotatedWith(RestHeaderParam.class);
    }

    public List<RestParameter> getPostParameters() {
        return this.getRestParametersAnnotatedWith(RestPostParam.class);
    }

    public RestParameter getPayloadParameter() {
        for (VariableElement variableElement : ((ExecutableElement)this.innerElement).getParameters()) {
            if (variableElement.getAnnotation(RestUriParam.class) != null || variableElement.getAnnotation(RestQueryParam.class) != null || variableElement.getAnnotation(RestPostParam.class) != null || variableElement.getAnnotation(RestHeaderParam.class) != null) continue;
            return new AnnotationProcessorRestParameter(variableElement, this, this.types, this.elements);
        }
        return null;
    }

    public Boolean payloadIsBinary() {
        RestParameter payloadParameter = this.getPayloadParameter();
        return payloadParameter != null && this.getPayloadParameter().getAnnotation(BinaryParam.class) != null;
    }

    public List<RestExceptionOn> getExceptions() {
        if (((ExecutableElement)this.innerElement).getAnnotation(org.mule.api.annotations.rest.RestCall.class) == null) {
            return null;
        }
        if (((ExecutableElement)this.innerElement).getAnnotation(org.mule.api.annotations.rest.RestCall.class).exceptions().length == 0) {
            return null;
        }
        ArrayList<RestExceptionOn> exceptions = new ArrayList<RestExceptionOn>();
        List<AnnotationMirror> annotationMirrors = this.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!org.mule.api.annotations.rest.RestCall.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"exceptions".equals(entry.getKey().getSimpleName().toString())) continue;
                for (AnnotationValue value : (List)entry.getValue().getValue()) {
                    AnnotationMirror secondMirror = AnnotationUtils.getAnnotationMirror(value);
                    DeclaredType exception = null;
                    String expression = "";
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> secondEntry : secondMirror.getElementValues().entrySet()) {
                        if ("exception".equals(secondEntry.getKey().getSimpleName().toString())) {
                            exception = (DeclaredType)secondEntry.getValue().getValue();
                        }
                        if (!"expression".equals(secondEntry.getKey().getSimpleName().toString())) continue;
                        expression = (String)secondEntry.getValue().getValue();
                    }
                    Type realType = null;
                    if (exception != null) {
                        realType = (Type)AnnotationProcessorTypeFactory.createType((TypeElement)exception.asElement(), this.types, this.elements, this.components);
                    }
                    exceptions.add(new RestAnnotationProcessorExceptionOn(expression, realType));
                }
            }
        }
        return exceptions;
    }

    public RestTimeout getTimeout() {
        if (((ExecutableElement)this.innerElement).getAnnotation(org.mule.api.annotations.rest.RestCall.class) == null || ((ExecutableElement)this.innerElement).getAnnotation(org.mule.api.annotations.rest.RestTimeout.class) == null) {
            return null;
        }
        String restTimeoutName = org.mule.api.annotations.rest.RestTimeout.class.getName();
        DeclaredType exception = null;
        int timeout = 0;
        List<AnnotationMirror> annotationMirrors = this.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!restTimeoutName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if ("exception".equals(entry.getKey().getSimpleName().toString())) {
                    exception = (DeclaredType)entry.getValue().getValue();
                    continue block0;
                }
                if (!"timeout".equals(entry.getKey().getSimpleName().toString())) continue;
                timeout = (Integer)entry.getValue().getValue();
            }
        }
        Type realType = null;
        if (exception != null) {
            realType = (Type)AnnotationProcessorTypeFactory.createType((TypeElement)exception.asElement(), this.types, this.elements, this.components);
        }
        return new RestAnnotationProcessorTimeout(timeout, realType);
    }

    private List<RestParameter> getRestParametersAnnotatedWith(Class<? extends Annotation> annotation) {
        ArrayList<RestParameter> parameters = new ArrayList<RestParameter>();
        for (VariableElement variableElement : ((ExecutableElement)this.innerElement).getParameters()) {
            if (variableElement.getAnnotation(annotation) == null) continue;
            parameters.add(new AnnotationProcessorRestParameter(variableElement, this, this.types, this.elements));
        }
        return parameters;
    }
}

