/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model.generic.types;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.mule.devkit.apt.model.generic.types.AbstractGenericType;
import org.mule.devkit.model.GenericType;

public class DeclaredGenericType
extends AbstractGenericType {
    private Element element;
    private final List<String> COLLECTION_NAMES = Arrays.asList("Collection", "List", "Set", "Queue", "Deque");

    public DeclaredGenericType(Element element) {
        super(element.asType());
        this.element = element;
    }

    public Optional<Element> getElement() {
        return Optional.fromNullable((Object)this.element);
    }

    public boolean hasMetaData() {
        if (this.type.getKind() == TypeKind.DECLARED && this.isMetaData()) {
            return true;
        }
        for (GenericType genericType : this.getGenericTypeArguments()) {
            if (!genericType.hasMetaData()) continue;
            return true;
        }
        return false;
    }

    public boolean isList() {
        return "List".equals(this.getElementSimpleName());
    }

    public boolean isMap() {
        return "Map".equals(this.getElementSimpleName());
    }

    public boolean is(String typeName) {
        return typeName.equals(this.getElementSimpleName());
    }

    private boolean isMapOfStringObject() {
        return "Map".equals(this.getElementSimpleName()) && !this.getGenericTypeArguments().isEmpty() && this.getGenericTypeArguments().size() == 2 && "String".equals(((Element)this.getGenericTypeArguments().get(0).getElement().get()).getSimpleName().toString()) && "Object".equals(((Element)this.getGenericTypeArguments().get(1).getElement().get()).getSimpleName().toString());
    }

    private String getElementSimpleName() {
        return this.element.getSimpleName() == null ? "" : this.element.getSimpleName().toString();
    }

    public boolean isMetaData() {
        return this.isMapOfStringObject();
    }

    public boolean isCollection() {
        return this.COLLECTION_NAMES.contains(this.getElementSimpleName());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getElementSimpleName());
        if (!this.genericTypeArguments.isEmpty()) {
            result.append("<").append(this.genericsToString()).append(">");
        }
        return result.toString();
    }

    public String fullQualifiedName() {
        StringBuilder result = new StringBuilder();
        result.append(this.element.toString());
        if (!this.genericTypeArguments.isEmpty()) {
            result.append("<");
            Iterator iterator = this.genericTypeArguments.iterator();
            result.append(((GenericType)iterator.next()).fullQualifiedName());
            while (iterator.hasNext()) {
                result.append(",").append(((GenericType)iterator.next()).fullQualifiedName());
            }
            result.append(">");
        }
        return result.toString();
    }

    private String genericsToString() {
        StringBuilder generics = new StringBuilder();
        Iterator iterator = this.genericTypeArguments.iterator();
        generics.append(((GenericType)iterator.next()).toString());
        while (iterator.hasNext()) {
            generics.append(",").append(((GenericType)iterator.next()).toString());
        }
        return generics.toString();
    }
}

