/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model.factory;

import com.google.common.base.Optional;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.devkit.apt.model.factory.GenericTypeFactory;
import org.mule.devkit.apt.model.generic.types.AbstractGenericType;
import org.mule.devkit.apt.model.generic.types.DeclaredGenericType;
import org.mule.devkit.apt.model.generic.types.NonDeclaredGenericType;

public class DefaultGenericTypeFactory
implements GenericTypeFactory {
    @Override
    public Optional<? extends AbstractGenericType> createGenericType(TypeMirror type, Types types, Elements elements, Element innerElement, String name) {
        if (this.isDeclaredType(type)) {
            DeclaredGenericType root = new DeclaredGenericType(types.asElement(type));
            for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                if (this.isWildcardType(typeMirror) || this.isTypeVariable(typeMirror)) continue;
                if (this.isDeclaredType(typeMirror)) {
                    Element element = types.asElement(typeMirror);
                    DeclaredGenericType child = new DeclaredGenericType(element);
                    root.addGenericChildTypeArgument(child);
                    this.generateInnerTypeIfNecessary(types, elements, innerElement, name, typeMirror, element, child);
                    continue;
                }
                root.addGenericChildTypeArgument(new NonDeclaredGenericType(typeMirror));
            }
            return Optional.of((Object)root);
        }
        if (this.isVoid(type) || this.isPrimitiveType(type) || this.isArray(type)) {
            return Optional.of((Object)new NonDeclaredGenericType(type));
        }
        return Optional.absent();
    }

    @Override
    public void generateInnerTypeIfNecessary(Types types, Elements elements, Element innerElement, String name, TypeMirror typeMirror, Element element, AbstractGenericType child) {
        Name nt = (Name)elements.getName("inner" + name);
        Symbol.ClassSymbol tempElement = new Symbol.ClassSymbol(0L, nt, (Type)typeMirror, ((Symbol)innerElement).owner);
        ((Type.ClassType)((Symbol.ClassSymbol)element).type).typarams_field = ((Type.ClassType)tempElement.type).typarams_field;
        for (Type t : ((Type.ClassType)((Symbol.ClassSymbol)element).type).typarams_field) {
            if (!this.isDeclaredType(t)) continue;
            child.addGenericChildTypeArgument((AbstractGenericType)this.createGenericType(t, types, elements, innerElement, name).get());
        }
    }

    private boolean isArray(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.ARRAY;
    }

    private boolean isTypeVariable(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.TYPEVAR;
    }

    private boolean isWildcardType(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.WILDCARD;
    }

    private boolean isDeclaredType(TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED;
    }

    private boolean isPrimitiveType(TypeMirror type) {
        return type.getKind().isPrimitive();
    }

    private boolean isVoid(TypeMirror type) {
        return type.getKind() == TypeKind.VOID;
    }
}

