/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.dependency;

import org.mule.devkit.apt.dependency.Version;

final class VersionRange {
    private final Version lowerBound;
    private final boolean lowerBoundInclusive;
    private final Version upperBound;
    private final boolean upperBoundInclusive;

    public VersionRange(String range) {
        String process = range;
        if (range.startsWith("[")) {
            this.lowerBoundInclusive = true;
        } else if (range.startsWith("(")) {
            this.lowerBoundInclusive = false;
        } else {
            throw new RuntimeException("Invalid version range " + range + ", a range must start with either [ or (");
        }
        if (range.endsWith("]")) {
            this.upperBoundInclusive = true;
        } else if (range.endsWith(")")) {
            this.upperBoundInclusive = false;
        } else {
            throw new RuntimeException("Invalid version range " + range + ", a range must end with either [ or (");
        }
        process = process.substring(1, process.length() - 1);
        int index = process.indexOf(",");
        if (index < 0) {
            if (!this.lowerBoundInclusive || !this.upperBoundInclusive) {
                throw new RuntimeException("Invalid version range " + range + ", single version must be surrounded by []");
            }
            this.lowerBound = this.upperBound = new Version(process.trim());
        } else {
            String parsedLowerBound = process.substring(0, index).trim();
            String parsedUpperBound = process.substring(index + 1).trim();
            if (parsedUpperBound.contains(",")) {
                throw new RuntimeException("Invalid version range " + range + ", bounds may not contain additional ','");
            }
            this.lowerBound = parsedLowerBound.length() > 0 ? new Version(parsedLowerBound) : null;
            Version version = this.upperBound = parsedUpperBound.length() > 0 ? new Version(parsedUpperBound) : null;
            if (this.upperBound != null && this.lowerBound != null && this.upperBound.compareTo(this.lowerBound) < 0) {
                throw new RuntimeException("Invalid version range " + range + ", lower bound must not be greater than upper bound");
            }
        }
    }

    public VersionRange(Version lowerBound, boolean lowerBoundInclusive, Version upperBound, boolean upperBoundInclusive) {
        this.lowerBound = lowerBound;
        this.lowerBoundInclusive = lowerBoundInclusive;
        this.upperBound = upperBound;
        this.upperBoundInclusive = upperBoundInclusive;
    }

    public Version getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerBoundInclusive() {
        return this.lowerBoundInclusive;
    }

    public Version getUpperBound() {
        return this.upperBound;
    }

    public boolean isUpperBoundInclusive() {
        return this.upperBoundInclusive;
    }

    public boolean containsVersion(Version version) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.compareTo(version);
            if (comparison == 0 && !this.lowerBoundInclusive) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.compareTo(version);
            if (comparison == 0 && !this.upperBoundInclusive) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        VersionRange that = (VersionRange)obj;
        return this.upperBoundInclusive == that.upperBoundInclusive && this.lowerBoundInclusive == that.lowerBoundInclusive && VersionRange.eq(this.upperBound, that.upperBound) && VersionRange.eq(this.lowerBound, that.lowerBound);
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + VersionRange.hash(this.upperBound);
        hash = hash * 31 + (this.upperBoundInclusive ? 1 : 0);
        hash = hash * 31 + VersionRange.hash(this.lowerBound);
        hash = hash * 31 + (this.lowerBoundInclusive ? 1 : 0);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(this.lowerBoundInclusive ? (char)'[' : '(');
        if (this.lowerBound != null) {
            buffer.append(this.lowerBound);
        }
        buffer.append(',');
        if (this.upperBound != null) {
            buffer.append(this.upperBound);
        }
        buffer.append(this.upperBoundInclusive ? (char)']' : ')');
        return buffer.toString();
    }
}

